/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.tree;

import java.util.Set;
import org.apache.tapestry5.BaseOptimizedSessionPersistedObject;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.tree.TreeNode;
import org.apache.tapestry5.tree.TreeSelectionModel;

public class DefaultTreeSelectionModel<T>
extends BaseOptimizedSessionPersistedObject
implements TreeSelectionModel<T> {
    private static final long serialVersionUID = -2568582442906389898L;
    private final Set<String> selectedIds = CollectionFactory.newSet();

    @Override
    public boolean isSelected(TreeNode<T> node) {
        assert (node != null);
        return this.selectedIds.contains(node.getId());
    }

    @Override
    public void select(TreeNode<T> node) {
        assert (node != null);
        if (this.selectedIds.add(node.getId())) {
            this.markDirty();
        }
    }

    @Override
    public void unselect(TreeNode<T> node) {
        assert (node != null);
        if (this.selectedIds.remove(node.getId())) {
            this.markDirty();
        }
    }

    @Override
    public void clear() {
        if (!this.selectedIds.isEmpty()) {
            this.selectedIds.clear();
            this.markDirty();
        }
    }
}

