/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.util.List;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.Orderable;
import org.apache.tapestry5.ioc.internal.util.UtilMessages;
import org.slf4j.Logger;

class DependencyNode<T> {
    private final Logger logger;
    private final Orderable<T> orderable;
    private final List<DependencyNode<T>> dependencies = CollectionFactory.newList();

    DependencyNode(Logger logger, Orderable<T> orderable) {
        this.logger = logger;
        this.orderable = orderable;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(String.format("[%s", this.getId()));
        boolean first = true;
        for (DependencyNode<T> node : this.dependencies) {
            buffer.append(first ? ": " : ", ");
            buffer.append(node.toString());
            first = false;
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String getId() {
        return this.orderable.getId();
    }

    void addDependency(DependencyNode<T> node) {
        if (node.isReachable(this)) {
            this.logger.warn(UtilMessages.dependencyCycle(node, this));
            return;
        }
        this.dependencies.add(node);
    }

    boolean isReachable(DependencyNode<T> node) {
        if (this == node) {
            return true;
        }
        for (DependencyNode<T> d : this.dependencies) {
            if (d != node) continue;
            return true;
        }
        for (DependencyNode<T> d : this.dependencies) {
            if (!d.isReachable(node)) continue;
            return true;
        }
        return false;
    }

    List<Orderable<T>> getOrdered() {
        List result = CollectionFactory.newList();
        this.fillOrder(result);
        return result;
    }

    private void fillOrder(List<Orderable<T>> list) {
        if (list.contains(this.orderable)) {
            return;
        }
        for (DependencyNode<T> node : this.dependencies) {
            super.fillOrder(list);
        }
        list.add(this.orderable);
    }
}

