/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.junit;

import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.junit.TestRegistryManager;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class TapestryIOCJUnit4ClassRunner
extends BlockJUnit4ClassRunner {
    private final TestRegistryManager registryManager;

    public TapestryIOCJUnit4ClassRunner(Class<?> type) throws InitializationError {
        super(type);
        this.registryManager = new TestRegistryManager(type);
    }

    public void run(RunNotifier notifier) {
        RegistryManagerRunNotifier wrapper = new RegistryManagerRunNotifier(this.registryManager, notifier);
        super.run((RunNotifier)wrapper);
    }

    protected Statement withAfterClasses(Statement statement) {
        final Statement superStatement = super.withAfterClasses(statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                superStatement.evaluate();
                TapestryIOCJUnit4ClassRunner.this.registryManager.afterTestClass();
            }
        };
    }

    protected Object createTest() throws Exception {
        Registry registry = this.registryManager.getOrCreateRegistry();
        return registry.autobuild(this.getTestClass().getJavaClass());
    }

    public static class RegistryManagerRunNotifier
    extends RunNotifier {
        private final RunNotifier delegate;
        private final TestRegistryManager registryManager;

        public RegistryManagerRunNotifier(TestRegistryManager registryManager, RunNotifier delegate) {
            this.delegate = delegate;
            this.registryManager = registryManager;
        }

        public void addListener(RunListener listener) {
            this.delegate.addListener(listener);
        }

        public void removeListener(RunListener listener) {
            this.delegate.removeListener(listener);
        }

        public void fireTestRunStarted(Description description) {
            this.delegate.fireTestRunStarted(description);
        }

        public void fireTestRunFinished(Result result) {
            this.delegate.fireTestRunFinished(result);
        }

        public void fireTestStarted(Description description) throws StoppedByUserException {
            this.delegate.fireTestStarted(description);
        }

        public void fireTestFailure(Failure failure) {
            this.delegate.fireTestFailure(failure);
        }

        public void fireTestAssumptionFailed(Failure failure) {
            this.delegate.fireTestAssumptionFailed(failure);
        }

        public void fireTestIgnored(Description description) {
            this.delegate.fireTestIgnored(description);
        }

        public void fireTestFinished(Description description) {
            this.registryManager.afterTestMethod();
            this.delegate.fireTestFinished(description);
        }

        public void pleaseStop() {
            this.delegate.pleaseStop();
        }

        public void addFirstListener(RunListener listener) {
            this.delegate.addFirstListener(listener);
        }
    }
}

