/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.internal.services.LinkSource;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.PageRenderLinkSource;

public class PageRenderLinkSourceImpl
implements PageRenderLinkSource {
    private final ComponentClassResolver resolver;
    private final LinkSource linkSource;

    public PageRenderLinkSourceImpl(LinkSource linkSource, ComponentClassResolver resolver) {
        this.linkSource = linkSource;
        this.resolver = resolver;
    }

    private String toPageName(Class pageClass) {
        return this.resolver.resolvePageClassNameToPageName(pageClass.getName());
    }

    @Override
    public Link createPageRenderLink(Class pageClass) {
        return this.createPageRenderLink(this.toPageName(pageClass));
    }

    @Override
    public Link createPageRenderLink(String pageName) {
        return this.linkSource.createPageRenderLink(pageName, false, new Object[0]);
    }

    @Override
    public Link createPageRenderLinkWithContext(Class pageClass, Object ... context) {
        return this.createPageRenderLinkWithContext(this.toPageName(pageClass), context);
    }

    @Override
    public Link createPageRenderLinkWithContext(Class pageClass, EventContext eventContext) {
        return this.createPageRenderLinkWithContext(this.toPageName(pageClass), eventContext);
    }

    @Override
    public Link createPageRenderLinkWithContext(String pageName, Object ... context) {
        return this.linkSource.createPageRenderLink(pageName, true, context);
    }

    @Override
    public Link createPageRenderLinkWithContext(String pageName, EventContext eventContext) {
        int count = eventContext.getCount();
        Object[] pageActivationContext = new Object[count];
        for (int i = 0; i < count; ++i) {
            pageActivationContext[i] = eventContext.get(Object.class, i);
        }
        return this.linkSource.createPageRenderLink(pageName, true, pageActivationContext);
    }
}

