/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.spring;

import javax.servlet.ServletContext;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.spring.ApplicationContextCustomizer;
import org.apache.tapestry5.spring.TapestryApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;

public class CustomizingContextLoader
extends ContextLoader {
    private final ApplicationContextCustomizer customizer;

    public CustomizingContextLoader(ApplicationContextCustomizer customizer) {
        this.customizer = customizer;
    }

    protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext applicationContext) {
        this.customizer.customizeApplicationContext(servletContext, applicationContext);
    }

    protected Class determineContextClass(ServletContext servletContext) throws ApplicationContextException {
        String contextClassName = servletContext.getInitParameter("contextClass");
        if (InternalUtils.isNonBlank((String)contextClassName)) {
            Class result = super.determineContextClass(servletContext);
            if (!TapestryApplicationContext.class.isAssignableFrom(result)) {
                throw new IllegalArgumentException(String.format("When using the Tapestry/Spring integration library, you must specifiy a context class that extends from %s. Class %s does not. Update the '%s' servlet context init parameter.", TapestryApplicationContext.class.getName(), result.getName(), "contextClass"));
            }
            return result;
        }
        return TapestryApplicationContext.class;
    }
}

