/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import java.util.Locale;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.http.services.BaseURLSource;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.LinkImpl;
import org.apache.tapestry5.internal.services.RequestSecurityManager;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentEventLinkEncoder;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ContextPathEncoder;
import org.apache.tapestry5.services.LocalizationSetter;
import org.apache.tapestry5.services.MetaDataLocator;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.PersistentLocale;
import org.apache.tapestry5.services.security.ClientWhitelist;

public class ComponentEventLinkEncoderImpl
implements ComponentEventLinkEncoder {
    private final ComponentClassResolver componentClassResolver;
    private final ContextPathEncoder contextPathEncoder;
    private final LocalizationSetter localizationSetter;
    private final Response response;
    private final RequestSecurityManager requestSecurityManager;
    private final BaseURLSource baseURLSource;
    private final PersistentLocale persistentLocale;
    private final boolean encodeLocaleIntoPath;
    private final MetaDataLocator metaDataLocator;
    private final ClientWhitelist clientWhitelist;
    private final String contextPath;
    private final String applicationFolder;
    private final String applicationFolderPrefix;
    private static final int BUFFER_SIZE = 100;
    private static final char SLASH = '/';

    public ComponentEventLinkEncoderImpl(ComponentClassResolver componentClassResolver, ContextPathEncoder contextPathEncoder, LocalizationSetter localizationSetter, Response response, RequestSecurityManager requestSecurityManager, BaseURLSource baseURLSource, PersistentLocale persistentLocale, @Symbol(value="tapestry.encode-locale-into-path") boolean encodeLocaleIntoPath, @Symbol(value="tapestry.context-path") String contextPath, @Symbol(value="tapestry.application-folder") String applicationFolder, MetaDataLocator metaDataLocator, ClientWhitelist clientWhitelist) {
        this.componentClassResolver = componentClassResolver;
        this.contextPathEncoder = contextPathEncoder;
        this.localizationSetter = localizationSetter;
        this.response = response;
        this.requestSecurityManager = requestSecurityManager;
        this.baseURLSource = baseURLSource;
        this.persistentLocale = persistentLocale;
        this.encodeLocaleIntoPath = encodeLocaleIntoPath;
        this.contextPath = contextPath;
        this.applicationFolder = applicationFolder;
        this.metaDataLocator = metaDataLocator;
        this.clientWhitelist = clientWhitelist;
        boolean hasAppFolder = applicationFolder.equals("");
        this.applicationFolderPrefix = hasAppFolder ? null : '/' + applicationFolder;
    }

    @Override
    public Link createPageRenderLink(PageRenderRequestParameters parameters) {
        StringBuilder builder = new StringBuilder(100);
        String activePageName = parameters.getLogicalPageName();
        builder.append(this.contextPath);
        this.encodeAppFolderAndLocale(builder);
        builder.append('/');
        String encodedPageName = this.encodePageName(activePageName);
        builder.append(encodedPageName);
        this.appendContext(encodedPageName.length() > 0, parameters.getActivationContext(), builder);
        LinkImpl link = new LinkImpl(builder.toString(), false, this.requestSecurityManager.checkPageSecurity(activePageName), this.response, this.contextPathEncoder, this.baseURLSource);
        if (parameters.isLoopback()) {
            link.addParameter("t:lb", "t");
        }
        return link;
    }

    private void encodeAppFolderAndLocale(StringBuilder builder) {
        Locale locale;
        if (!this.applicationFolder.equals("")) {
            builder.append('/').append(this.applicationFolder);
        }
        if (this.encodeLocaleIntoPath && (locale = this.persistentLocale.get()) != null) {
            builder.append('/');
            builder.append(locale.toString());
        }
    }

    private String encodePageName(String pageName) {
        if (pageName.equalsIgnoreCase("index")) {
            return "";
        }
        String encoded = pageName.toLowerCase();
        if (!encoded.endsWith("/index")) {
            return encoded;
        }
        return encoded.substring(0, encoded.length() - 6);
    }

    @Override
    public Link createComponentEventLink(ComponentEventRequestParameters parameters, boolean forForm) {
        StringBuilder builder = new StringBuilder(100);
        String activePageName = parameters.getActivePageName();
        String containingPageName = parameters.getContainingPageName();
        String eventType = parameters.getEventType();
        String nestedComponentId = parameters.getNestedComponentId();
        boolean hasComponentId = InternalUtils.isNonBlank((String)nestedComponentId);
        builder.append(this.contextPath);
        this.encodeAppFolderAndLocale(builder);
        builder.append('/');
        builder.append(activePageName.toLowerCase());
        if (hasComponentId) {
            builder.append('.');
            builder.append(nestedComponentId);
        }
        if (!hasComponentId || !eventType.equals("action")) {
            builder.append(':');
            builder.append(this.encodePageName(eventType));
        }
        this.appendContext(true, parameters.getEventContext(), builder);
        LinkImpl result = new LinkImpl(builder.toString(), forForm, this.requestSecurityManager.checkPageSecurity(activePageName), this.response, this.contextPathEncoder, this.baseURLSource);
        EventContext pageActivationContext = parameters.getPageActivationContext();
        if (pageActivationContext.getCount() != 0) {
            builder.setLength(0);
            this.appendContext(true, pageActivationContext, builder);
            result.addParameter("t:ac", builder.substring(1));
        }
        if (!containingPageName.equalsIgnoreCase(activePageName)) {
            result.addParameter("t:cp", this.encodePageName(containingPageName));
        }
        return result;
    }

    private List<String> splitPath(String path) {
        String[] split = TapestryInternalUtils.splitPath(path);
        List result = CollectionFactory.newList();
        for (String name : split) {
            if (name.length() <= 0) continue;
            result.add(name);
        }
        return result;
    }

    private String joinPath(List<String> path) {
        if (path.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(100);
        String sep = "";
        for (String term : path) {
            builder.append(sep).append(term);
            sep = "/";
        }
        return builder.toString();
    }

    @Override
    public ComponentEventRequestParameters decodeComponentEventRequest(Request request) {
        List<String> path;
        String explicitLocale = null;
        String requestPath = request.getPath();
        if (this.applicationFolderPrefix != null) {
            requestPath = this.removeApplicationPrefix(requestPath);
        }
        if ((path = this.splitPath(requestPath)).isEmpty()) {
            return null;
        }
        String potentialLocale = path.get(0);
        if (this.localizationSetter.isSupportedLocaleName(potentialLocale)) {
            explicitLocale = potentialLocale;
            path.remove(0);
        }
        StringBuilder pageName = new StringBuilder(100);
        String sep = "";
        while (!path.isEmpty()) {
            int dotx;
            String name = path.remove(0);
            String eventType = "action";
            String nestedComponentId = "";
            boolean found = false;
            int colonx = name.lastIndexOf(58);
            if (colonx > 0) {
                found = true;
                eventType = name.substring(colonx + 1);
                name = name.substring(0, colonx);
            }
            if ((dotx = name.indexOf(46)) > 0) {
                found = true;
                nestedComponentId = name.substring(dotx + 1);
                name = name.substring(0, dotx);
            }
            pageName.append(sep).append(name);
            if (found) {
                ComponentEventRequestParameters result = this.validateAndConstructComponentEventRequest(request, pageName.toString(), nestedComponentId, eventType, path);
                if (result == null) {
                    return result;
                }
                if (explicitLocale == null) {
                    this.localizationSetter.setNonPersistentLocaleFromRequest(request);
                } else {
                    this.localizationSetter.setLocaleFromLocaleName(explicitLocale);
                }
                return result;
            }
            sep = "/";
        }
        return null;
    }

    private ComponentEventRequestParameters validateAndConstructComponentEventRequest(Request request, String pageName, String nestedComponentId, String eventType, List<String> remainingPath) {
        if (!this.componentClassResolver.isPageName(pageName)) {
            return null;
        }
        String activePageName = this.componentClassResolver.canonicalizePageName(pageName);
        if (this.isWhitelistOnlyAndNotValid(activePageName)) {
            return null;
        }
        String value = request.getParameter("t:cp");
        String containingPageName = value == null ? activePageName : this.componentClassResolver.canonicalizePageName(value);
        EventContext eventContext = this.contextPathEncoder.decodePath(this.joinPath(remainingPath));
        EventContext activationContext = this.contextPathEncoder.decodePath(request.getParameter("t:ac"));
        return new ComponentEventRequestParameters(activePageName, containingPageName, nestedComponentId, eventType, activationContext, eventContext);
    }

    @Override
    public PageRenderRequestParameters decodePageRenderRequest(Request request) {
        String possibleLocaleName;
        String extendedName;
        boolean explicitLocale = false;
        String path = request.getPath();
        if (this.applicationFolderPrefix != null) {
            path = this.removeApplicationPrefix(path);
        }
        String string = extendedName = path.length() == 0 ? path : path.substring(1);
        while (extendedName.endsWith("/")) {
            extendedName = extendedName.substring(0, extendedName.length() - 1);
        }
        int slashx = extendedName.indexOf(47);
        String string2 = possibleLocaleName = slashx > 0 ? extendedName.substring(0, slashx) : extendedName;
        if (this.localizationSetter.setLocaleFromLocaleName(possibleLocaleName)) {
            extendedName = slashx > 0 ? extendedName.substring(slashx + 1) : "";
            explicitLocale = true;
        }
        slashx = extendedName.length();
        boolean atEnd = true;
        while (slashx > 0) {
            String pageActivationContext;
            String pageName = extendedName.substring(0, slashx);
            PageRenderRequestParameters parameters = this.checkIfPage(request, pageName, pageActivationContext = atEnd ? "" : extendedName.substring(slashx + 1));
            if (parameters != null) {
                return parameters;
            }
            slashx = extendedName.lastIndexOf(47, slashx - 1);
            atEnd = false;
        }
        PageRenderRequestParameters result = this.checkIfPage(request, "", extendedName);
        if (result != null && !explicitLocale) {
            this.localizationSetter.setNonPersistentLocaleFromRequest(request);
        }
        return result;
    }

    private String removeApplicationPrefix(String path) {
        int prefixLength = this.applicationFolderPrefix.length();
        assert (path.substring(0, prefixLength).equalsIgnoreCase(this.applicationFolderPrefix));
        assert (path.length() <= prefixLength || path.charAt(prefixLength) == '/');
        path = path.substring(prefixLength);
        return path;
    }

    private PageRenderRequestParameters checkIfPage(Request request, String pageName, String pageActivationContext) {
        if (!this.componentClassResolver.isPageName(pageName)) {
            return null;
        }
        String canonicalized = this.componentClassResolver.canonicalizePageName(pageName);
        if (this.isWhitelistOnlyAndNotValid(canonicalized)) {
            return null;
        }
        try {
            EventContext activationContext = this.contextPathEncoder.decodePath(pageActivationContext);
            boolean loopback = request.getParameter("t:lb") != null;
            return new PageRenderRequestParameters(canonicalized, activationContext, loopback);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean isWhitelistOnlyAndNotValid(String canonicalized) {
        return this.metaDataLocator.findMeta("tapestry.white-list-only-page", canonicalized, Boolean.TYPE) != false && !this.clientWhitelist.isClientRequestOnWhitelist();
    }

    public void appendContext(boolean seperatorRequired, EventContext context, StringBuilder builder) {
        String encoded = this.contextPathEncoder.encodeIntoPath(context);
        if (encoded.length() > 0) {
            if (seperatorRequired) {
                builder.append('/');
            }
            builder.append(encoded);
        }
    }
}

