/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.api.AlwaysOnException;
import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.api.AsynchronousNonBlocking;
import io.smallrye.faulttolerance.api.BeforeRetry;
import io.smallrye.faulttolerance.api.CircuitBreakerName;
import io.smallrye.faulttolerance.api.CustomBackoff;
import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RetryWhen;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ApplyFaultToleranceConfig;
import io.smallrye.faulttolerance.config.ApplyFaultToleranceConfigImpl;
import io.smallrye.faulttolerance.config.AsynchronousConfig;
import io.smallrye.faulttolerance.config.AsynchronousConfigImpl;
import io.smallrye.faulttolerance.config.AsynchronousNonBlockingConfig;
import io.smallrye.faulttolerance.config.AsynchronousNonBlockingConfigImpl;
import io.smallrye.faulttolerance.config.BeforeRetryConfig;
import io.smallrye.faulttolerance.config.BeforeRetryConfigImpl;
import io.smallrye.faulttolerance.config.BlockingConfig;
import io.smallrye.faulttolerance.config.BlockingConfigImpl;
import io.smallrye.faulttolerance.config.BulkheadConfig;
import io.smallrye.faulttolerance.config.BulkheadConfigImpl;
import io.smallrye.faulttolerance.config.CircuitBreakerConfig;
import io.smallrye.faulttolerance.config.CircuitBreakerConfigImpl;
import io.smallrye.faulttolerance.config.CircuitBreakerNameConfig;
import io.smallrye.faulttolerance.config.CircuitBreakerNameConfigImpl;
import io.smallrye.faulttolerance.config.CustomBackoffConfig;
import io.smallrye.faulttolerance.config.CustomBackoffConfigImpl;
import io.smallrye.faulttolerance.config.ExponentialBackoffConfig;
import io.smallrye.faulttolerance.config.ExponentialBackoffConfigImpl;
import io.smallrye.faulttolerance.config.FallbackConfig;
import io.smallrye.faulttolerance.config.FallbackConfigImpl;
import io.smallrye.faulttolerance.config.FibonacciBackoffConfig;
import io.smallrye.faulttolerance.config.FibonacciBackoffConfigImpl;
import io.smallrye.faulttolerance.config.NonBlockingConfig;
import io.smallrye.faulttolerance.config.NonBlockingConfigImpl;
import io.smallrye.faulttolerance.config.RateLimitConfig;
import io.smallrye.faulttolerance.config.RateLimitConfigImpl;
import io.smallrye.faulttolerance.config.RetryConfig;
import io.smallrye.faulttolerance.config.RetryConfigImpl;
import io.smallrye.faulttolerance.config.RetryWhenConfig;
import io.smallrye.faulttolerance.config.RetryWhenConfigImpl;
import io.smallrye.faulttolerance.config.TimeoutConfig;
import io.smallrye.faulttolerance.config.TimeoutConfigImpl;
import io.smallrye.faulttolerance.core.util.Durations;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class FaultToleranceOperation {
    private final Class<?> beanClass;
    private final MethodDescriptor methodDescriptor;
    private final ApplyFaultToleranceConfig applyFaultTolerance;
    private final AsynchronousConfig asynchronous;
    private final AsynchronousNonBlockingConfig asynchronousNonBlocking;
    private final BlockingConfig blocking;
    private final NonBlockingConfig nonBlocking;
    private final BulkheadConfig bulkhead;
    private final CircuitBreakerConfig circuitBreaker;
    private final CircuitBreakerNameConfig circuitBreakerName;
    private final FallbackConfig fallback;
    private final RateLimitConfig rateLimit;
    private final RetryConfig retry;
    private final TimeoutConfig timeout;
    private final ExponentialBackoffConfig exponentialBackoff;
    private final FibonacciBackoffConfig fibonacciBackoff;
    private final CustomBackoffConfig customBackoff;
    private final RetryWhenConfig retryWhen;
    private final BeforeRetryConfig beforeRetry;

    public static FaultToleranceOperation create(FaultToleranceMethod method) {
        return new FaultToleranceOperation(method.beanClass, method.method, ApplyFaultToleranceConfigImpl.create(method), AsynchronousConfigImpl.create(method), AsynchronousNonBlockingConfigImpl.create(method), BlockingConfigImpl.create(method), NonBlockingConfigImpl.create(method), BulkheadConfigImpl.create(method), CircuitBreakerConfigImpl.create(method), CircuitBreakerNameConfigImpl.create(method), FallbackConfigImpl.create(method), RateLimitConfigImpl.create(method), RetryConfigImpl.create(method), TimeoutConfigImpl.create(method), ExponentialBackoffConfigImpl.create(method), FibonacciBackoffConfigImpl.create(method), CustomBackoffConfigImpl.create(method), RetryWhenConfigImpl.create(method), BeforeRetryConfigImpl.create(method));
    }

    private FaultToleranceOperation(Class<?> beanClass, MethodDescriptor methodDescriptor, ApplyFaultToleranceConfig applyFaultTolerance, AsynchronousConfig asynchronous, AsynchronousNonBlockingConfig asynchronousNonBlocking, BlockingConfig blocking, NonBlockingConfig nonBlocking, BulkheadConfig bulkhead, CircuitBreakerConfig circuitBreaker, CircuitBreakerNameConfig circuitBreakerName, FallbackConfig fallback, RateLimitConfig rateLimit, RetryConfig retry, TimeoutConfig timeout, ExponentialBackoffConfig exponentialBackoff, FibonacciBackoffConfig fibonacciBackoff, CustomBackoffConfig customBackoff, RetryWhenConfig retryWhen, BeforeRetryConfig beforeRetry) {
        this.beanClass = beanClass;
        this.methodDescriptor = methodDescriptor;
        this.applyFaultTolerance = applyFaultTolerance;
        this.asynchronous = asynchronous;
        this.asynchronousNonBlocking = asynchronousNonBlocking;
        this.blocking = blocking;
        this.nonBlocking = nonBlocking;
        this.bulkhead = bulkhead;
        this.circuitBreaker = circuitBreaker;
        this.circuitBreakerName = circuitBreakerName;
        this.fallback = fallback;
        this.rateLimit = rateLimit;
        this.retry = retry;
        this.timeout = timeout;
        this.exponentialBackoff = exponentialBackoff;
        this.fibonacciBackoff = fibonacciBackoff;
        this.customBackoff = customBackoff;
        this.retryWhen = retryWhen;
        this.beforeRetry = beforeRetry;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public Class<?>[] getParameterTypes() {
        return this.methodDescriptor.parameterTypes;
    }

    public Class<?> getReturnType() {
        return this.methodDescriptor.returnType;
    }

    public boolean hasApplyFaultTolerance() {
        return this.applyFaultTolerance != null;
    }

    public ApplyFaultTolerance getApplyFaultTolerance() {
        return this.applyFaultTolerance;
    }

    public boolean hasAsynchronous() {
        return this.asynchronous != null;
    }

    public Asynchronous getAsynchronous() {
        return this.asynchronous;
    }

    public boolean hasAsynchronousNonBlocking() {
        return this.asynchronousNonBlocking != null;
    }

    public AsynchronousNonBlocking getAsynchronousNonBlocking() {
        return this.asynchronousNonBlocking;
    }

    public boolean hasBlocking() {
        return this.blocking != null;
    }

    public Blocking getBlocking() {
        return this.blocking;
    }

    public boolean hasNonBlocking() {
        return this.nonBlocking != null;
    }

    public NonBlocking getNonBlocking() {
        return this.nonBlocking;
    }

    public boolean isThreadOffloadRequired() {
        if (this.blocking == null && this.nonBlocking == null) {
            if (this.asynchronousNonBlocking != null && this.asynchronousNonBlocking.isOnMethod()) {
                return false;
            }
            if (this.asynchronous != null && this.asynchronous.isOnMethod()) {
                return true;
            }
            if (this.asynchronousNonBlocking != null) {
                return false;
            }
            return this.asynchronous != null;
        }
        if (this.blocking != null && this.blocking.isOnMethod()) {
            return true;
        }
        if (this.nonBlocking != null && this.nonBlocking.isOnMethod()) {
            return false;
        }
        if (this.asynchronousNonBlocking != null && this.asynchronousNonBlocking.isOnMethod()) {
            return false;
        }
        if (this.blocking != null) {
            return true;
        }
        if (this.nonBlocking != null) {
            return false;
        }
        if (this.asynchronousNonBlocking != null) {
            return false;
        }
        return this.asynchronous != null;
    }

    public boolean hasBulkhead() {
        return this.bulkhead != null;
    }

    public Bulkhead getBulkhead() {
        return this.bulkhead;
    }

    public boolean hasCircuitBreaker() {
        return this.circuitBreaker != null;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public boolean hasCircuitBreakerName() {
        return this.circuitBreakerName != null;
    }

    public CircuitBreakerName getCircuitBreakerName() {
        return this.circuitBreakerName;
    }

    public boolean hasFallback() {
        return this.fallback != null;
    }

    public Fallback getFallback() {
        return this.fallback;
    }

    public boolean hasRateLimit() {
        return this.rateLimit != null;
    }

    public RateLimit getRateLimit() {
        return this.rateLimit;
    }

    public boolean hasRetry() {
        return this.retry != null;
    }

    public Retry getRetry() {
        return this.retry;
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public boolean hasExponentialBackoff() {
        return this.exponentialBackoff != null;
    }

    public ExponentialBackoff getExponentialBackoff() {
        return this.exponentialBackoff;
    }

    public boolean hasFibonacciBackoff() {
        return this.fibonacciBackoff != null;
    }

    public FibonacciBackoff getFibonacciBackoff() {
        return this.fibonacciBackoff;
    }

    public boolean hasCustomBackoff() {
        return this.customBackoff != null;
    }

    public CustomBackoff getCustomBackoff() {
        return this.customBackoff;
    }

    public boolean hasRetryWhen() {
        return this.retryWhen != null;
    }

    public RetryWhen getRetryWhen() {
        return this.retryWhen;
    }

    public boolean hasBeforeRetry() {
        return this.beforeRetry != null;
    }

    public BeforeRetry getBeforeRetry() {
        return this.beforeRetry;
    }

    public String getName() {
        return this.beanClass.getCanonicalName() + "." + this.methodDescriptor.name;
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (FaultToleranceDefinitionException e) {
            return false;
        }
    }

    public void validate() {
        if (this.applyFaultTolerance != null) {
            this.applyFaultTolerance.validate();
        }
        if (this.asynchronous != null) {
            this.asynchronous.validate();
        }
        if (this.asynchronousNonBlocking != null) {
            this.asynchronousNonBlocking.validate();
        }
        if (this.blocking != null) {
            this.blocking.validate();
        }
        if (this.nonBlocking != null) {
            this.nonBlocking.validate();
        }
        if (this.bulkhead != null) {
            this.bulkhead.validate();
        }
        if (this.circuitBreaker != null) {
            this.circuitBreaker.validate();
        }
        if (this.fallback != null) {
            this.fallback.validate();
        }
        if (this.rateLimit != null) {
            this.rateLimit.validate();
        }
        if (this.retry != null) {
            this.retry.validate();
        }
        if (this.timeout != null) {
            this.timeout.validate();
        }
        this.validateRetryBackoff();
        this.validateRetryWhen();
        this.validateBeforeRetry();
    }

    private void validateRetryBackoff() {
        long retryMaxDuration;
        HashSet<Class> backoffAnnotations = new HashSet<Class>();
        for (Config cfg : Arrays.asList(this.exponentialBackoff, this.fibonacciBackoff, this.customBackoff)) {
            if (cfg == null) continue;
            cfg.validate();
            if (this.retry == null) {
                throw new FaultToleranceDefinitionException("Invalid @" + cfg.annotationType().getSimpleName() + " on " + String.valueOf(this.methodDescriptor) + ": missing @Retry");
            }
            backoffAnnotations.add(cfg.annotationType());
        }
        if (backoffAnnotations.size() > 1) {
            throw new FaultToleranceDefinitionException("More than one backoff defined for " + String.valueOf(this.methodDescriptor) + ": " + String.valueOf(backoffAnnotations));
        }
        if (this.retry != null && (retryMaxDuration = Durations.timeInMillis((long)this.retry.maxDuration(), (ChronoUnit)this.retry.durationUnit())) > 0L) {
            long maxDelay;
            if (this.exponentialBackoff != null && retryMaxDuration <= (maxDelay = Durations.timeInMillis((long)this.exponentialBackoff.maxDelay(), (ChronoUnit)this.exponentialBackoff.maxDelayUnit()))) {
                throw new FaultToleranceDefinitionException("Invalid @ExponentialBackoff on " + String.valueOf(this.methodDescriptor) + ": @Retry.maxDuration should be greater than maxDelay");
            }
            if (this.fibonacciBackoff != null && retryMaxDuration <= (maxDelay = Durations.timeInMillis((long)this.fibonacciBackoff.maxDelay(), (ChronoUnit)this.fibonacciBackoff.maxDelayUnit()))) {
                throw new FaultToleranceDefinitionException("Invalid @FibonacciBackoff on " + String.valueOf(this.methodDescriptor) + ": @Retry.maxDuration should be greater than maxDelay");
            }
        }
    }

    private void validateRetryWhen() {
        if (this.retryWhen == null) {
            return;
        }
        this.retryWhen.validate();
        if (this.retry == null) {
            throw new FaultToleranceDefinitionException("Invalid @RetryWhen on " + String.valueOf(this.methodDescriptor) + ": missing @Retry");
        }
        if (this.retryWhen.exception() != AlwaysOnException.class) {
            if (this.retry.abortOn().length != 0) {
                throw new FaultToleranceDefinitionException("Invalid @RetryWhen.exception on " + String.valueOf(this.methodDescriptor) + ": must not be combined with @Retry.abortOn");
            }
            if (this.retry.retryOn().length != 1 || this.retry.retryOn()[0] != Exception.class) {
                throw new FaultToleranceDefinitionException("Invalid @RetryWhen.exception on " + String.valueOf(this.methodDescriptor) + ": must not be combined with @Retry.retryOn");
            }
        }
    }

    private void validateBeforeRetry() {
        if (this.beforeRetry == null) {
            return;
        }
        this.beforeRetry.validate();
        if (this.retry == null) {
            throw new FaultToleranceDefinitionException("Invalid @BeforeRetry on " + String.valueOf(this.methodDescriptor) + ": missing @Retry");
        }
    }

    public void materialize() {
        if (this.applyFaultTolerance != null) {
            this.applyFaultTolerance.materialize();
        }
        if (this.asynchronous != null) {
            this.asynchronous.materialize();
        }
        if (this.asynchronousNonBlocking != null) {
            this.asynchronousNonBlocking.materialize();
        }
        if (this.blocking != null) {
            this.blocking.materialize();
        }
        if (this.nonBlocking != null) {
            this.nonBlocking.materialize();
        }
        if (this.bulkhead != null) {
            this.bulkhead.materialize();
        }
        if (this.circuitBreaker != null) {
            this.circuitBreaker.materialize();
        }
        if (this.circuitBreakerName != null) {
            this.circuitBreakerName.materialize();
        }
        if (this.fallback != null) {
            this.fallback.materialize();
        }
        if (this.rateLimit != null) {
            this.rateLimit.materialize();
        }
        if (this.retry != null) {
            this.retry.materialize();
        }
        if (this.timeout != null) {
            this.timeout.materialize();
        }
        if (this.exponentialBackoff != null) {
            this.exponentialBackoff.materialize();
        }
        if (this.fibonacciBackoff != null) {
            this.fibonacciBackoff.materialize();
        }
        if (this.customBackoff != null) {
            this.customBackoff.materialize();
        }
        if (this.retryWhen != null) {
            this.retryWhen.materialize();
        }
        if (this.beforeRetry != null) {
            this.beforeRetry.materialize();
        }
    }

    public String toString() {
        return "FaultToleranceOperation[" + String.valueOf(this.methodDescriptor) + "]";
    }
}

