/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.uniffle.proto.RssProtos;

public enum ServerStatus {
    ACTIVE(0),
    DECOMMISSIONING(1),
    DECOMMISSIONED(2),
    LOST(3),
    UNHEALTHY(4),
    UNKNOWN(-1);

    static final Map<Integer, ServerStatus> VALUE_MAP;
    private final int code;

    private ServerStatus(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public static ServerStatus fromCode(Integer code) {
        ServerStatus serverStatus = VALUE_MAP.get(code);
        return serverStatus == null ? UNKNOWN : serverStatus;
    }

    public RssProtos.ServerStatus toProto() {
        RssProtos.ServerStatus serverStatus = RssProtos.ServerStatus.forNumber((int)this.code());
        return serverStatus == null ? RssProtos.ServerStatus.UNRECOGNIZED : serverStatus;
    }

    public static ServerStatus fromProto(RssProtos.ServerStatus status) {
        return ServerStatus.fromCode(status.getNumber());
    }

    static {
        VALUE_MAP = Arrays.stream(ServerStatus.values()).collect(Collectors.toMap(ServerStatus::code, s -> s));
    }
}

