/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.compression;

import java.nio.ByteBuffer;
import org.apache.uniffle.common.compression.Codec;

public class NoOpCodec
extends Codec {
    public static NoOpCodec getInstance() {
        return LazyHolder.INSTANCE;
    }

    @Override
    public void decompress(ByteBuffer src, int uncompressedLen, ByteBuffer dest, int destOffset) {
        dest.put(src);
        dest.position(destOffset);
        dest.limit(destOffset + uncompressedLen);
    }

    @Override
    public byte[] compress(byte[] src) {
        byte[] dst = new byte[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Override
    public int compress(ByteBuffer src, ByteBuffer dest) {
        int destOff = dest.position();
        dest.put(src.duplicate());
        return dest.position() - destOff;
    }

    @Override
    public int maxCompressedLength(int sourceLength) {
        return sourceLength;
    }

    private static class LazyHolder {
        static final NoOpCodec INSTANCE = new NoOpCodec();

        private LazyHolder() {
        }
    }
}

