/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.access.checker;

import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.coordinator.AccessManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.QuotaManager;
import org.apache.uniffle.coordinator.access.AccessCheckResult;
import org.apache.uniffle.coordinator.access.AccessInfo;
import org.apache.uniffle.coordinator.access.checker.AbstractAccessChecker;
import org.apache.uniffle.coordinator.metric.CoordinatorMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessQuotaChecker
extends AbstractAccessChecker {
    private static final Logger LOG = LoggerFactory.getLogger(AccessQuotaChecker.class);
    private final QuotaManager quotaManager;
    private final CoordinatorConf conf;
    private static final LongAdder COUNTER = new LongAdder();
    private final String hostIp;

    public AccessQuotaChecker(AccessManager accessManager) throws Exception {
        super(accessManager);
        this.conf = accessManager.getCoordinatorConf();
        this.quotaManager = accessManager.getQuotaManager();
        this.hostIp = RssUtils.getHostIp();
    }

    @Override
    public AccessCheckResult check(AccessInfo accessInfo) {
        COUNTER.increment();
        String uuid = this.hostIp.hashCode() + "-" + COUNTER.sum();
        String user = accessInfo.getUser();
        if (!"".equals(user) && this.quotaManager.checkQuota(user, uuid)) {
            String msg = "Denied by AccessQuotaChecker => User: " + user + ", current app num is: " + this.quotaManager.getCurrentUserAndApp().get(user).size() + ", default app num is: " + this.quotaManager.getDefaultUserApps().get(user) + ". We will reject this app[uuid=" + uuid + "].";
            LOG.error(msg);
            CoordinatorMetrics.counterTotalQuotaDeniedRequest.inc();
            return new AccessCheckResult(false, msg);
        }
        return new AccessCheckResult(true, "SUCCESS", uuid);
    }

    @Override
    public void close() throws IOException {
    }
}

