/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage;

import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.storage.AbstractStorageManagerFallbackStrategy;
import org.apache.uniffle.server.storage.StorageManager;

public class RotateStorageManagerFallbackStrategy
extends AbstractStorageManagerFallbackStrategy {
    private final Long fallBackTimes;

    public RotateStorageManagerFallbackStrategy(ShuffleServerConf conf) {
        super(conf);
        this.fallBackTimes = (Long)conf.get(ShuffleServerConf.FALLBACK_MAX_FAIL_TIMES);
    }

    @Override
    public StorageManager tryFallback(StorageManager current, ShuffleDataFlushEvent event, StorageManager ... candidates) {
        if (this.fallBackTimes > 0L && ((long)event.getRetryTimes() < this.fallBackTimes || (long)event.getRetryTimes() % this.fallBackTimes > 0L)) {
            return current;
        }
        return this.findNextStorageManager(current, null, event, candidates);
    }
}

