/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.axiom.ts.om.element.sr;

import javax.xml.stream.XMLStreamReader;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.ts.AxiomTestCase;

public class TestNextTag extends AxiomTestCase {
    public TestNextTag(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMElement element = AXIOMUtil.stringToOM(metaFactory.getOMFactory(),
                "<a> <b> </b> <?pi?> <!--comment--> <c/> </a>");
        XMLStreamReader stream = element.getXMLStreamReaderWithoutCaching();
        assertEquals(XMLStreamReader.START_ELEMENT, stream.next());
        stream.nextTag();
        assertEquals(XMLStreamReader.START_ELEMENT, stream.getEventType());
        assertEquals("b", stream.getLocalName());
        stream.nextTag();
        assertEquals(XMLStreamReader.END_ELEMENT, stream.getEventType());
        stream.nextTag();
        assertEquals(XMLStreamReader.START_ELEMENT, stream.getEventType());
        assertEquals("c", stream.getLocalName());
        element.close(false);
    }
}
