/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  The ASF licenses this file to You
 * under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.  For additional information regarding
 * copyright in this work, please see the NOTICE file in the top level
 * directory of this distribution.
 */
package org.apache.abdera.parser.stax;

import org.apache.abdera.model.Comment;
import org.apache.axiom.fom.AbderaComment;
import org.apache.axiom.om.impl.intf.AxiomComment;

public final class FOMComment extends FOMLeafNode implements AbderaComment, AxiomComment {
    public String getText() {
        return getValue();
    }

    public Comment setText(String text) {
        setValue(text);
        return this;
    }

    public String toString() {
        java.io.CharArrayWriter w = new java.io.CharArrayWriter();
        try {
            super.serialize(w);
        } catch (Exception e) {
        }
        return w.toString();
    }
}
