/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.ds;

import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlHandlerWrapper;
import org.apache.axiom.core.stream.XmlReader;
import org.apache.axiom.core.stream.stax.push.XmlHandlerStreamWriter;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;
import org.apache.axiom.om.impl.mixin.AxiomChildNodeSupport;
import org.apache.axiom.om.impl.stream.XmlDeclarationRewriterHandler;
import org.apache.axiom.om.impl.stream.ds.MTOMXMLStreamWriterImpl;
import org.apache.axiom.om.impl.stream.ds.PushOMDataSourceStreamWriter;
import org.apache.axiom.om.impl.stream.ds.PushOMDataSourceXOPHandler;
import org.apache.axiom.om.impl.stream.stax.push.AxiomXMLStreamWriterExtensionFactory;

final class PushOMDataSourceReader
implements XmlReader {
    private final XmlHandler handler;
    private final AxiomSourcedElement root;
    private final OMDataSource dataSource;

    PushOMDataSourceReader(XmlHandler handler, AxiomSourcedElement root, OMDataSource dataSource) {
        this.handler = handler;
        this.root = root;
        this.dataSource = dataSource;
    }

    @Override
    public boolean proceed() throws StreamException {
        XmlHandler handler = this.handler;
        OMOutputFormat format = null;
        XmlHandler current = handler;
        while (current instanceof XmlHandlerWrapper) {
            if (current instanceof XmlDeclarationRewriterHandler) {
                format = ((XmlDeclarationRewriterHandler)current).getFormat();
                break;
            }
            current = ((XmlHandlerWrapper)current).getParent();
        }
        if (format == null) {
            format = new OMOutputFormat();
            format.setDoOptimize(true);
            handler = new PushOMDataSourceXOPHandler(handler);
        }
        try {
            XmlHandlerStreamWriter writer = new XmlHandlerStreamWriter(handler, null, AxiomXMLStreamWriterExtensionFactory.INSTANCE);
            OMContainer parent = AxiomChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomChildNodeSupport$org_apache_axiom_om_impl_intf_AxiomChildNode$getParent(this.root);
            if (parent instanceof OMElement) {
                Iterator<OMNamespace> it = ((OMElement)parent).getNamespacesInScope();
                while (it.hasNext()) {
                    OMNamespace ns = it.next();
                    writer.setPrefix(ns.getPrefix(), ns.getNamespaceURI());
                }
            }
            handler.startFragment();
            this.dataSource.serialize(new MTOMXMLStreamWriterImpl(new PushOMDataSourceStreamWriter(writer), format));
            handler.completed();
        }
        catch (XMLStreamException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof StreamException) {
                throw (StreamException)cause;
            }
            throw new StreamException(ex);
        }
        return true;
    }

    @Override
    public void dispose() {
    }
}

