
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Using insertBefore on this Document node attempt to insert a new Comment node before
 *  this DocumentElement node and verify the name of the inserted Comment node.  Now
 *  attempt to insert a new Processing Instruction node before the new Comment and 
 *  verify the target of the inserted ProcessingInstruction.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-952280727">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-952280727</a>
*/
public final class nodeinsertbefore01 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodeinsertbefore01(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element docElem;
      Comment newComment;
      Comment insertedComment;
      String data;
      ProcessingInstruction newPI;
      ProcessingInstruction insertedPI;
      String target;
      doc = (Document) load("hc_staff", true);
      docElem = doc.getDocumentElement();
      newComment = doc.createComment("Comment");
      newPI = doc.createProcessingInstruction("PITarget", "PIData");
      insertedComment = (Comment) doc.insertBefore(newComment, docElem);
      data = insertedComment.getData();
      assertEquals("nodeinsertbefore01_1", "Comment", data);
      insertedPI = (ProcessingInstruction) doc.insertBefore(newPI, newComment);
      target = insertedPI.getTarget();
      assertEquals("nodeinsertbefore01_2", "PITarget", target);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodeinsertbefore01";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodeinsertbefore01.class, args);
   }
}

