/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.gnupg;

import com.freiheit.gnupg.GnuPGData;
import com.freiheit.gnupg.GnuPGException;
import com.freiheit.gnupg.GnuPGKey;
import com.freiheit.gnupg.GnuPGPassphraseListener;
import com.freiheit.gnupg.GnuPGPeer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class GnuPGContext
extends GnuPGPeer {
    private String _version;
    private String _filename;
    private String _reqversion;
    private static GnuPGPassphraseListener __passphraseListener = null;

    public GnuPGContext() {
        this.gpgmeGetEngineInfo();
        this.setInternalRepresentation(this.gpgmeNew());
    }

    public String getVersion() {
        return this._version;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getRequiredVersion() {
        return this._reqversion;
    }

    public boolean isArmor() {
        int armorState = this.gpgmeGetArmor(this.getInternalRepresentation());
        return armorState == 1;
    }

    public void setArmor(boolean state) {
        int armorState = state ? 1 : 0;
        this.gpgmeSetArmor(this.getInternalRepresentation(), armorState);
    }

    public boolean isTextmode() {
        boolean result = false;
        int mode = this.gpgmeGetTextmode(this.getInternalRepresentation());
        if (mode == 1) {
            result = true;
        }
        return result;
    }

    public void setTextmode(boolean state) {
        int mode = state ? 1 : 0;
        this.gpgmeSetTextmode(this.getInternalRepresentation(), mode);
    }

    public void setPassphraseListener(GnuPGPassphraseListener l) {
        __passphraseListener = l;
    }

    private static synchronized String passphraseCallback(String hint, String passphraseInfo, int wasBad) {
        return __passphraseListener.getPassphrase(hint, passphraseInfo, wasBad);
    }

    private int[] getInternalRepresentationFromRecipients(GnuPGKey[] recipients) {
        int[] recipientsInternals = new int[recipients.length];
        for (int i = 0; i < recipients.length; ++i) {
            if (recipients[i] == null) {
                return null;
            }
            recipientsInternals[i] = recipients[i].getInternalRepresentation();
        }
        return recipientsInternals;
    }

    private boolean hasNoRecipients(GnuPGKey[] recipients) {
        return recipients == null || recipients.length <= 0;
    }

    public GnuPGKey getKeyByFingerprint(String fingerprint) throws GnuPGException {
        if (fingerprint == null || fingerprint.length() < 1) {
            return null;
        }
        return new GnuPGKey(this, fingerprint);
    }

    public GnuPGData createDataObject(String data) throws GnuPGException {
        if (data == null || data.length() < 1) {
            return null;
        }
        return new GnuPGData(data);
    }

    public GnuPGData createDataObject(byte[] data) throws GnuPGException {
        if (data == null || data.length < 1) {
            return null;
        }
        return new GnuPGData(data);
    }

    public GnuPGData createDataObject() throws GnuPGException {
        return new GnuPGData();
    }

    public GnuPGKey[] generateEmptyKeyArray(int withLengthOf) {
        if (withLengthOf < 1) {
            return null;
        }
        return new GnuPGKey[withLengthOf];
    }

    public GnuPGKey[] searchKeys(String query) throws GnuPGException {
        if (query == null || query.length() < 1) {
            return null;
        }
        return this.gpgmeKeylist(this.getInternalRepresentation(), query);
    }

    public void encrypt(GnuPGKey[] recipients, GnuPGData plain, GnuPGData cipher) throws GnuPGException {
        if (this.hasNoRecipients(recipients) || plain == null || cipher == null) {
            throw new GnuPGException("Encryption-Arguments not complete.");
        }
        int[] recipientsInternals = this.getInternalRepresentationFromRecipients(recipients);
        this.gpgmeOpEncrypt(this.getInternalRepresentation(), recipientsInternals, plain.getInternalRepresentation(), cipher.getInternalRepresentation());
    }

    public void decrypt(GnuPGData cipher, GnuPGData plain) throws GnuPGException {
        if (__passphraseListener == null) {
            throw new GnuPGException("Aborting: No GnuPGPassphraseListener set.");
        }
        if (cipher == null || plain == null) {
            return;
        }
        this.gpgmeOpDecrypt(this.getInternalRepresentation(), cipher.getInternalRepresentation(), plain.getInternalRepresentation());
    }

    public void sign(GnuPGData plain, GnuPGData signature) throws GnuPGException {
        if (__passphraseListener == null) {
            throw new GnuPGException("Aborting: No GnuPGPassphraseListener set.");
        }
        if (plain == null || signature == null) {
            throw new GnuPGException("Parameters not complete or null.");
        }
        this.gpgmeOpSign(this.getInternalRepresentation(), plain.getInternalRepresentation(), signature.getInternalRepresentation());
    }

    public void verify(GnuPGData signature, GnuPGData signed, GnuPGData plain) throws GnuPGException {
        if (signature == null || signed == null || plain == null) {
            throw new GnuPGException("Parameters not complete or null.");
        }
        this.gpgmeOpVerify(this.getInternalRepresentation(), signature.getInternalRepresentation(), signed.getInternalRepresentation(), plain.getInternalRepresentation());
    }

    public void addSigner(GnuPGKey key) throws GnuPGException {
        if (key == null) {
            throw new GnuPGException("Parameters not complete or null.");
        }
        this.gpgmeAddSigners(this.getInternalRepresentation(), key.getInternalRepresentation());
    }

    public void clearSigners() throws GnuPGException {
        this.gpgmeClearSigners(this.getInternalRepresentation());
    }

    public void destroy() {
        if (this.getInternalRepresentation() != 0) {
            this.gpgmeRelease(this.getInternalRepresentation());
            this.setInternalRepresentation(0);
        }
    }

    protected void finalize() {
        this.destroy();
    }

    private static native void gpgmeCheckVersion();

    private native void gpgmeGetEngineInfo();

    private native int gpgmeNew();

    private native void gpgmeOpEncrypt(int var1, int[] var2, int var3, int var4);

    private native void gpgmeOpDecrypt(int var1, int var2, int var3);

    private native void gpgmeRelease(int var1);

    private native void gpgmeOpEncryptSign(int var1, int[] var2, int var3, int var4);

    private native void gpgmeOpDecryptVerify(int var1, int var2, int var3);

    private native void gpgmeOpSign(int var1, int var2, int var3);

    private native void gpgmeOpVerify(int var1, int var2, int var3, int var4);

    private native GnuPGKey[] gpgmeKeylist(int var1, String var2);

    private native void gpgmeAddSigners(int var1, int var2);

    private native void gpgmeClearSigners(int var1);

    private native int gpgmeGetArmor(int var1);

    private native void gpgmeSetArmor(int var1, int var2);

    private native int gpgmeGetTextmode(int var1);

    private native void gpgmeSetTextmode(int var1, int var2);

    static {
        try {
            InputStream in = GnuPGContext.class.getResource("/libjavagnupg.so").openStream();
            File tempLib = File.createTempFile("libjavagnupg", ".so");
            FileOutputStream out = new FileOutputStream(tempLib);
            byte[] buf = new byte[4096];
            int i = in.read(buf);
            while (i != -1) {
                out.write(buf, 0, i);
                i = in.read(buf);
            }
            out.close();
            tempLib.deleteOnExit();
            System.load(tempLib.getPath());
            GnuPGContext.gpgmeCheckVersion();
        }
        catch (Exception e) {
            System.out.println("Unable to load shared library from Jar-File.");
            System.out.println("Maybe GnuPG for Java is not allowed to write to your disk? (Access problems?)");
            e.printStackTrace();
        }
    }
}

