/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.jce;

import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.hash.HashFactory;
import gnu.crypto.mac.MacFactory;
import gnu.crypto.sig.KeyPairGeneratorFactory;
import gnu.crypto.sig.SignatureFactory;
import java.security.Provider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class GnuCrypto
extends Provider {
    public GnuCrypto() {
        super("GNU-CRYPTO", 1.1, "GNU Crypto JCE Provider");
        this.put("MessageDigest.MD2", "gnu.crypto.jce.hash.MD2Spi");
        this.put("MessageDigest.MD2 ImplementedIn", "Software");
        this.put("MessageDigest.MD4", "gnu.crypto.jce.hash.MD4Spi");
        this.put("MessageDigest.MD4 ImplementedIn", "Software");
        this.put("MessageDigest.MD5", "gnu.crypto.jce.hash.MD5Spi");
        this.put("MessageDigest.MD5 ImplementedIn", "Software");
        this.put("MessageDigest.RIPEMD128", "gnu.crypto.jce.hash.RipeMD128Spi");
        this.put("MessageDigest.RIPEMD128 ImplementedIn", "Software");
        this.put("MessageDigest.RIPEMD160", "gnu.crypto.jce.hash.RipeMD160Spi");
        this.put("MessageDigest.RIPEMD160 ImplementedIn", "Software");
        this.put("MessageDigest.SHA-160", "gnu.crypto.jce.hash.Sha160Spi");
        this.put("MessageDigest.SHA-160 ImplementedIn", "Software");
        this.put("MessageDigest.WHIRLPOOL", "gnu.crypto.jce.hash.WhirlpoolSpi");
        this.put("MessageDigest.WHIRLPOOL ImplementedIn", "Software");
        this.put("SecureRandom.ARCFOUR", "gnu.crypto.jce.prng.ARCFourRandomSpi");
        this.put("SecureRandom.MD2PRNG", "gnu.crypto.jce.prng.MD2RandomSpi");
        this.put("SecureRandom.MD2PRNG ImplementedIn", "Software");
        this.put("SecureRandom.MD4PRNG", "gnu.crypto.jce.prng.MD4RandomSpi");
        this.put("SecureRandom.MD4PRNG ImplementedIn", "Software");
        this.put("SecureRandom.MD5PRNG", "gnu.crypto.jce.prng.MD5RandomSpi");
        this.put("SecureRandom.MD5PRNG ImplementedIn", "Software");
        this.put("SecureRandom.RIPEMD128PRNG", "gnu.crypto.jce.prng.RipeMD128RandomSpi");
        this.put("SecureRandom.RIPEMD128PRNG ImplementedIn", "Software");
        this.put("SecureRandom.RIPEMD160PRNG", "gnu.crypto.jce.prng.RipeMD160RandomSpi");
        this.put("SecureRandom.RIPEMD160PRNG ImplementedIn", "Software");
        this.put("SecureRandom.SHA-160PRNG", "gnu.crypto.jce.prng.Sha160RandomSpi");
        this.put("SecureRandom.SHA-160PRNG ImplementedIn", "Software");
        this.put("SecureRandom.WHIRLPOOLPRNG", "gnu.crypto.jce.prng.WhirlpoolRandomSpi");
        this.put("SecureRandom.WHIRLPOOLPRNG ImplementedIn", "Software");
        this.put("SecureRandom.ICM", "gnu.crypto.jce.prng.ICMRandomSpi");
        this.put("SecureRandom.ICM ImplementedIn", "Software");
        this.put("SecureRandom.UMAC-KDF", "gnu.crypto.jce.prng.UMacRandomSpi");
        this.put("SecureRandom.UMAC-KDF ImplementedIn", "Software");
        this.put("KeyPairGenerator.DSS", "gnu.crypto.jce.sig.DSSKeyPairGeneratorSpi");
        this.put("KeyPairGenerator.DSS KeySize", "1024");
        this.put("KeyPairGenerator.DSS ImplementedIn", "Software");
        this.put("KeyPairGenerator.RSA", "gnu.crypto.jce.sig.RSAKeyPairGeneratorSpi");
        this.put("KeyPairGenerator.RSA KeySize", "1024");
        this.put("KeyPairGenerator.RSA ImplementedIn", "Software");
        this.put("Signature.DSS/RAW", "gnu.crypto.jce.sig.DSSRawSignatureSpi");
        this.put("Signature.DSS/RAW KeySize", "1024");
        this.put("Signature.DSS/RAW ImplementedIn", "Software");
        this.put("Signature.RSA-PSS/RAW", "gnu.crypto.jce.sig.RSAPSSRawSignatureSpi");
        this.put("Signature.RSA-PSS/RAW KeySize", "1024");
        this.put("Signature.RSA-PSS/RAW ImplementedIn", "Software");
        this.put("Cipher.ANUBIS", "gnu.crypto.jce.cipher.AnubisSpi");
        this.put("Cipher.ANUBIS ImplementedIn", "Software");
        this.put("Cipher.ARCFOUR", "gnu.crypto.jce.cipher.ARCFourSpi");
        this.put("Cipher.ARCFOUR ImplementedIn", "Software");
        this.put("Cipher.BLOWFISH", "gnu.crypto.jce.cipher.BlowfishSpi");
        this.put("Cipher.BLOWFISH ImplementedIn", "Software");
        this.put("Cipher.DES", "gnu.crypto.jce.cipher.DESSpi");
        this.put("Cipher.DES ImplementedIn", "Software");
        this.put("Cipher.KHAZAD", "gnu.crypto.jce.cipher.KhazadSpi");
        this.put("Cipher.KHAZAD ImplementedIn", "Software");
        this.put("Cipher.NULL", "gnu.crypto.jce.cipher.NullCipherSpi");
        this.put("Cipher.NULL ImplementedIn", "Software");
        this.put("Cipher.AES", "gnu.crypto.jce.cipher.RijndaelSpi");
        this.put("Cipher.AES ImplementedIn", "Software");
        this.put("Cipher.RIJNDAEL", "gnu.crypto.jce.cipher.RijndaelSpi");
        this.put("Cipher.RIJNDAEL ImplementedIn", "Software");
        this.put("Cipher.SERPENT", "gnu.crypto.jce.cipher.SerpentSpi");
        this.put("Cipher.SERPENT ImplementedIn", "Software");
        this.put("Cipher.SQUARE", "gnu.crypto.jce.cipher.SquareSpi");
        this.put("Cipher.SQUARE ImplementedIn", "Software");
        this.put("Cipher.TRIPLEDES", "gnu.crypto.jce.cipher.TripleDESSpi");
        this.put("Cipher.TRIPLEDES ImplementedIn", "Software");
        this.put("Cipher.TWOFISH", "gnu.crypto.jce.cipher.TwofishSpi");
        this.put("Cipher.TWOFISH ImplementedIn", "Software");
        this.put("AlgorithmParameters.BlockCipherParameters", "gnu.crypto.jce.params.BlockCipherParameters");
        this.put("Mac.HMAC-MD2", "gnu.crypto.jce.mac.HMacMD2Spi");
        this.put("Mac.HMAC-MD4", "gnu.crypto.jce.mac.HMacMD4Spi");
        this.put("Mac.HMAC-MD5", "gnu.crypto.jce.mac.HMacMD5Spi");
        this.put("Mac.HMAC-SHA160", "gnu.crypto.jce.mac.HMacSHA160Spi");
        this.put("Mac.HMAC-RIPEMD160", "gnu.crypto.jce.mac.HMacRipeMD160Spi");
        this.put("Mac.HMAC-RIPEMD128", "gnu.crypto.jce.mac.HMacRipeMD128Spi");
        this.put("Mac.HMAC-WHIRLPOOL", "gnu.crypto.jce.mac.HMacWhirlpoolSpi");
        this.put("Mac.TMMH16", "gnu.crypto.jce.mac.TMMH16Spi");
        this.put("Mac.UHASH32", "gnu.crypto.jce.mac.UHash32Spi");
        this.put("Mac.UMAC32", "gnu.crypto.jce.mac.UMac32Spi");
        this.put("Alg.Alias.AlgorithmParameters.AES", "BlockCipherParameters");
        this.put("Alg.Alias.AlgorithmParameters.BLOWFISH", "BlockCipherParameters");
        this.put("Alg.Alias.AlgorithmParameters.ANUBIS", "BlockCipherParameters");
        this.put("Alg.Alias.AlgorithmParameters.KHAZAD", "BlockCipherParameters");
        this.put("Alg.Alias.AlgorithmParameters.NULL", "BlockCipherParameters");
        this.put("Alg.Alias.AlgorithmParameters.RIJNDAEL", "BlockCipherParameters");
        this.put("Alg.Alias.AlgorithmParameters.SERPENT", "BlockCipherParameters");
        this.put("Alg.Alias.AlgorithmParameters.SQUARE", "BlockCipherParameters");
        this.put("Alg.Alias.AlgorithmParameters.TWOFISH", "BlockCipherParameters");
        this.put("Alg.Alias.Cipher.RC4", "ARCFOUR");
        this.put("Alg.Alias.Cipher.3-DES", "TRIPLEDES");
        this.put("Alg.Alias.Cipher.3DES", "TRIPLEDES");
        this.put("Alg.Alias.Cipher.DES-EDE", "TRIPLEDES");
        this.put("Alg.Alias.Cipher.DESede", "TRIPLEDES");
        this.put("Alg.Alias.MessageDigest.SHS", "SHA-160");
        this.put("Alg.Alias.MessageDigest.SHA", "SHA-160");
        this.put("Alg.Alias.MessageDigest.SHA1", "SHA-160");
        this.put("Alg.Alias.MessageDigest.SHA-1", "SHA-160");
        this.put("Alg.Alias.MessageDigest.RIPEMD-160", "RIPEMD160");
        this.put("Alg.Alias.MessageDigest.RIPEMD-128", "RIPEMD128");
        this.put("Alg.Alias.Mac.HMAC-SHS", "HMAC-SHA160");
        this.put("Alg.Alias.Mac.HMAC-SHA", "HMAC-SHA160");
        this.put("Alg.Alias.Mac.HMAC-SHA1", "HMAC-SHA160");
        this.put("Alg.Alias.Mac.HMAC-SHA-160", "HMAC-SHA160");
        this.put("Alg.Alias.Mac.HMAC-RIPEMD-160", "HMAC-RIPEMD160");
        this.put("Alg.Alias.Mac.HMAC-RIPEMD-128", "HMAC-RIPEMD128");
        this.put("Alg.Alias.SecureRandom.RC4", "ARCFOUR");
        this.put("Alg.Alias.SecureRandom.SHA-1PRNG", "SHA-160PRNG");
        this.put("Alg.Alias.SecureRandom.SHA1PRNG", "SHA-160PRNG");
        this.put("Alg.Alias.SecureRandom.SHAPRNG", "SHA-160PRNG");
        this.put("Alg.Alias.KeyPairGenerator.DSA", "DSS");
        this.put("Alg.Alias.Signature.DSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHAwithDSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA1withDSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA160withDSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA/DSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA1/DSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA-1/DSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.SHA-160/DSA", "DSS/RAW");
        this.put("Alg.Alias.Signature.DSAwithSHA", "DSS/RAW");
        this.put("Alg.Alias.Signature.DSAwithSHA1", "DSS/RAW");
        this.put("Alg.Alias.Signature.DSAwithSHA160", "DSS/RAW");
        this.put("Alg.Alias.Signature.RSA-PSS", "RSA-PSS/RAW");
        this.put("Alg.Alias.Signature.RSAPSS", "RSA-PSS/RAW");
    }

    public static final Set getMessageDigestNames() {
        return HashFactory.getNames();
    }

    public static final Set getSecureRandomNames() {
        HashSet<String> result = new HashSet<String>();
        Set md = HashFactory.getNames();
        Iterator it = md.iterator();
        while (it.hasNext()) {
            result.add(((String)it.next()).toUpperCase() + "PRNG");
        }
        result.add("icm".toUpperCase());
        result.add("umac-kdf".toUpperCase());
        result.add("arcfour".toUpperCase());
        return Collections.unmodifiableSet(result);
    }

    public static final Set getKeyPairGeneratorNames() {
        return KeyPairGeneratorFactory.getNames();
    }

    public static final Set getSignatureNames() {
        return SignatureFactory.getNames();
    }

    public static final Set getCipherNames() {
        HashSet<String> s = new HashSet<String>();
        s.addAll(CipherFactory.getNames());
        s.add("arcfour");
        return s;
    }

    public static final Set getMacNames() {
        return MacFactory.getNames();
    }
}

