
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <gnutls/gnutls.h>

/* A TLS 1.0 client with session resuming capability.
 */

#define MAX_BUF 1024
#define CRLFILE "crl.pem"
#define CAFILE "ca.pem"
#define SA struct sockaddr
#define MSG "GET / HTTP/1.0\r\n\r\n"

const int protocol_priority[] = { GNUTLS_TLS1, GNUTLS_SSL3, 0 };
const int kx_priority[] = { GNUTLS_KX_RSA, GNUTLS_KX_DHE_RSA, 0 };
const int cipher_priority[] = { GNUTLS_CIPHER_3DES_CBC, GNUTLS_CIPHER_ARCFOUR_128, 0};
const int comp_priority[] = { GNUTLS_COMP_NULL, 0 };
const int mac_priority[] = { GNUTLS_MAC_SHA, GNUTLS_MAC_MD5, 0 };

int main()
{
   const char *PORT = "443";
   const char *SERVER = "127.0.0.1";
   int err, ret;
   int sd, ii, alert;
   struct sockaddr_in sa;
   gnutls_session session;
   char buffer[MAX_BUF + 1];
   gnutls_certificate_credentials xcred;
   /* variables used in session resuming */
   int t;
   char *session_data;
   char *session_id;
   int session_data_size;
   int session_id_size;
   char *tmp_session_id;
   int tmp_session_id_size;

   gnutls_global_init();

   /* X509 stuff 
    */
   gnutls_certificate_allocate_credentials(&xcred);

   gnutls_certificate_set_x509_trust_file(xcred, CAFILE, GNUTLS_X509_FMT_PEM);

   for (t = 0; t < 2; t++) {    /* connect 2 times to the server */

      sd = socket(AF_INET, SOCK_STREAM, 0);
      memset(&sa, '\0', sizeof(sa));
      sa.sin_family = AF_INET;
      sa.sin_port = htons(atoi(PORT));
      inet_pton(AF_INET, SERVER, &sa.sin_addr);

      err = connect(sd, (SA *) & sa, sizeof(sa));
      if (err < 0) {
         fprintf(stderr, "Connect error");
         exit(1);
      }
      gnutls_init(&session, GNUTLS_CLIENT);

      gnutls_protocol_set_priority(session, protocol_priority);
      gnutls_cipher_set_priority(session, cipher_priority);
      gnutls_compression_set_priority(session, comp_priority);
      gnutls_kx_set_priority(session, kx_priority);
      gnutls_mac_set_priority(session, mac_priority);

      gnutls_credentials_set(session, GNUTLS_CRD_CERTIFICATE, xcred);

      if (t > 0) { /* if this is not the first time we connect */
         gnutls_session_set_data(session, session_data, session_data_size);
         free(session_data);
      }
      
      gnutls_transport_set_ptr( session, sd);

      /* Perform the TLS handshake
       */
      ret = gnutls_handshake( session);

      if (ret < 0) {
         fprintf(stderr, "*** Handshake failed\n");
         gnutls_perror(ret);
         goto end;
      } else {
         printf("- Handshake was completed\n");
      }

      if (t == 0) { /* the first time we connect */
         /* get the session data size */
         gnutls_session_get_data(session, NULL, &session_data_size);
         session_data = malloc(session_data_size);

         /* put session data to the session variable */
         gnutls_session_get_data(session, session_data, &session_data_size);

         /* keep the current session ID. This is only needed
          * in order to check if the server actually resumed this
          * connection.
          */
         gnutls_session_get_id(session, NULL, &session_id_size);
         session_id = malloc(session_id_size);
         gnutls_session_get_id(session, session_id, &session_id_size);

      } else { /* the second time we connect */

         /* check if we actually resumed the previous session */
         gnutls_session_get_id(session, NULL, &tmp_session_id_size);
         tmp_session_id = malloc(tmp_session_id_size);
         gnutls_session_get_id(session, tmp_session_id, &tmp_session_id_size);

         if (memcmp(tmp_session_id, session_id, session_id_size) == 0) {
            printf("- Previous session was resumed\n");
         } else {
            fprintf(stderr, "*** Previous session was NOT resumed\n");
         }
         free(tmp_session_id);
         free(session_id);
      }

      /* This function was defined in a previous example
       */
      /* print_info(session); */

      gnutls_record_send( session, MSG, strlen(MSG));

      ret = gnutls_record_recv( session, buffer, MAX_BUF);
      if (ret == 0) {
         printf("- Peer has closed the TLS connection\n");
         goto end;
      } else if (ret < 0) {
         fprintf(stderr, "*** Error: %s\n", gnutls_strerror(ret));
         goto end;
      } else if (ret > 0) {
         printf("- Received %d bytes: ", ret);
         for (ii = 0; ii < ret; ii++) {
            fputc(buffer[ii], stdout);
         }
         fputs("\n", stdout);
      }
      gnutls_bye( session, GNUTLS_SHUT_RDWR);

    end:

      shutdown(sd, SHUT_RDWR);  /* no more receptions */
      close(sd);

      gnutls_deinit(session);

   }  /* for() */

   gnutls_certificate_free_credentials(xcred);

   gnutls_global_deinit();

   return 0;
}

