/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "transf.h"
#include "refs.h"
#include "str_fun.h"
#include "fl_ut.h"
#include "ix01_fun.h"
#include "sortix01.h"
#include "sortix02.h"
#include "ix02_fun.h"
#include "sortix03.h"
#include "ix03_fun.h"
#include "sortix04.h"
#include "ix04_fun.h"
#include "interf.h"
#include "initial.h"

#define MAXARR 32000
/* #define ABSTRACT_ZEILE_LEN 30600 */
#define MAX_BLOECKE 62
#define IMPORT_LOG "IMPORT.LOG"

 extern char journal_pix_name[PFAD_LEN+1];
 extern char desc_name[PFAD_LEN+1];
 extern char journal_name[PFAD_LEN+1];
 extern char book_name[PFAD_LEN+1];
 extern char autorjl_name[PFAD_LEN+1];
 extern char autorbu_name[PFAD_LEN+1];
 extern char quell_pix_name[PFAD_LEN+1];
 extern char quell_name[PFAD_LEN+1];
 extern char stichw_name[PFAD_LEN+1];
 extern char stichw_pix_name[PFAD_LEN+1];
 extern char abstr_pix_name[PFAD_LEN+1];
 extern char abstr_dat_name[PFAD_LEN+1];
 static char archiv_datei_name[PFAD_LEN+1];
 extern char log_name[PFAD_LEN+1];
 
 static char tmpix_name[PFAD_LEN+1];
 static char tmpixa_name[PFAD_LEN+1];
 static char newix_name[PFAD_LEN+1];

 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];


 static char * au_zeile;
 static char * ed_zeile;
 static char * desc_zeile;
 static char * ex_zeile;
 static char * in_zeile;
 static char * abs_zeile;
 
 
 extern FILE * ix01file;
 extern FILE * ix02file;
 extern FILE * ix03file;
 extern FILE * ix04file;
 
 extern FILE * fpjournal;
 extern FILE * fpdesc;
 extern FILE * fpbuch;
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;
 extern FILE * fparchiv;
 static FILE * tmpix;
 static FILE * tmpixa;
 extern FILE * fpquell;
 extern FILE * fpstichw;
 extern FILE * fpabs;
 extern FILE * fplog;
 
 
 extern config_set one_config_set;
 static int import_ok;
// 
//  static unsigned int delaywrite;
// 
// 
 extern journal_rec one_journal_rec;
 extern desc_rec one_desc_rec;
 extern buch_rec one_buch_rec;
 extern quell_rec one_quell_rec;
 static keylist_rec one_key_rec;
 extern abstr_rec one_abstr_rec;
 extern refspix_rec ix01rec;
 extern quellpix_rec ix02rec;
 extern keylistpix_rec ix03rec;
 extern abstrpix_rec ix04rec;
 
//  extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN+1];
 
 // static unsigned int blocks_required(const char * abstract);
 static void dateien0104_initialisieren(void);
 static void archiv_datei_lesen(const char * name);
 static void archiv_0104(void);
 static void aued_speichern(const char * zeile, FILE * fpaued, long * aued_rptr);
 static void desc_speichern(char * kennziffer,char * zeile);
  static void archiv_02(void);
  static void dateien02_initialisieren(void);
 static void archiv_03(void);
 static void dateien03_initialisieren(void);
 static int archiv_speichern(char * kennziffer, char * zeile);
 static int no_duplicates(char * archivname);
 static int no_dup0104(void);
 static int no_dup02(void);
 static int no_dup03(void);


int transf_main(void)
{
     static char ein[INPUT_BU_LEN+1];
     int loeschen_taste;
     import_ok = 1;
     if (datei_suchen_mit_pfad("*.arr",textpfad,archiv_datei_name))
     {
        sprintf(wrtxtbu,"\nArchive `%s' selected\n",archiv_datei_name);
        wrtxt(wrtxtbu);
     } else
     {
        wrtxt("\nNo archive file opened!\n");
        return 1;
     }
     strlimcpy(tmpix_name,rdbpfad,PFAD_LEN);
     strlimcat(tmpix_name,"TMP01.IX",PFAD_LEN);
     strlimcpy(tmpixa_name,rdbpfad,PFAD_LEN);
     strlimcat(tmpixa_name,"TMP02.IX",PFAD_LEN);
     strlimcpy(newix_name,rdbpfad,PFAD_LEN);
     strlimcat(newix_name,"NEW01.IX",PFAD_LEN);

     if (MAXARR < DESC_ZEILE_LEN)
     {
         fprintf(stderr,"\nProblem: buffer size inconsistency: "
                 "MAXARR, DESC_ZEILE_LEN\n");
         exit(1);
     }
     if ((au_zeile = (char *) malloc((MAXARR+1) * sizeof(char)))==NULL)
     {
        wrtxt("ERROR: IMPORT memory allocation 1\n");
        return 1;
     }
     if ((in_zeile = (char *) malloc((MAXARR+1) * sizeof(char)))==NULL)
     {
        wrtxt("ERROR: IMPORT memory allocation 2\n");
        return 1;
     }

     if ((ed_zeile = (char *) malloc((MAXARR+1) * sizeof(char)))==NULL)
     {
        wrtxt("ERROR: IMPORT memory allocation 3\n");
        return 1;
     }
     if ((ex_zeile = (char *) malloc((MAXARR+1) * sizeof(char)))==NULL)
     {
        wrtxt("ERROR: IMPORT memory allocation 4\n");
        return 1;
     }
     if ((abs_zeile = (char *) malloc((ABSTRACT_ZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("ERROR: IMPORT memory allocation 5\n");
        return 1;
     }
     if ((desc_zeile = (char *) malloc((DESC_ZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("ERROR: IMPORT memory allocation 6\n");
        return 1;
     }
     logdatei_oeffnen();


     /*
      * Gibt es doppelte Schluessel? Ab Version 3.5 muessen Schluessel nicht
      * mehr unbedingt sortiert (stets aber eindeutig) sein! Dies erleichtert
      * den Import von Daten aus der Version 2.4 und erlaubt in Zukunft
      * Aenderungen an der Sortierordnung! Deswegen muessen zu Beginn
      * Archivdateien mit Duplikaten in den Schluesseln vor dem Import
      * zurueckgewiesen werden. Die Funktion 'no_duplicates()' gibt '1'
      * zurueck, wenn keine doppelten Schluessel gefunden werden, sonst '0'
      */
     if (no_duplicates(archiv_datei_name)==0)
     {
        free(au_zeile);
        free(ed_zeile);
        free(in_zeile);
        free(ex_zeile);
        free(abs_zeile);
        free(desc_zeile);
        logdatei_schliessen();
        return 0;
     }

     archiv_datei_lesen(archiv_datei_name);
     dateien0104_initialisieren();

     sprintf(wrtxtbu,"\nIMPORT FROM ARCHIVE FILE - VERSION FOR REFERENCES %s\n",
       REFS_VERSION);
     wrtxt(wrtxtbu);


     while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
     {
       if (locate_substring("****:BEGIN ARCHIVE",in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
     }

     while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
     {
       if (locate_substring("****:BEGIN REFERENCES",in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
     }


     archiv_0104();

     close_ix01();
     close_ix04();
     fclose(tmpix);
     fclose(tmpixa);
     fclose(fpjournal);
     fclose(fpbuch);
     fclose(fpautorjl);
     fclose(fpautorbu);
     fclose(fpabs);
     fclose(fpdesc);
 

       /* Haupt-Index: */

       /* bei mehreren Datensaetzen muss tmpix_name sortiert werden: */

     if (filesize(tmpix_name) > sizeof(refspix_rec))
     {
       domerge01(tmpix_name,newix_name);
       remove(tmpix_name);
       rename(newix_name,tmpix_name);
     }
       /*
          Vier Faelle bei der Erstellung des neuen Haupt-Index:
          1.)  Ziel-Indexdatei noch leer
       */

     if (filesize(journal_pix_name) == 0)
     {
       remove(journal_pix_name);
       rename(tmpix_name,journal_pix_name);
       wrtxt("(Main index file created)\n");
     }

       /* 2.)  Quelldatei ist leer */

     else if (filesize(tmpix_name) == 0) // ergaenzt
     {
        remove(tmpix_name);
        wrtxt("(Main index file not touched)\n");
     }
       /*
          3.) Quell- und Zieldatei nicht leer, Quelldatei wird
              an Zeildatei angehaengt
       */
     else if (ok_appix01(journal_pix_name,tmpix_name))
     {
       appendix01(journal_pix_name,tmpix_name);
       remove(tmpix_name);
       wrtxt("(Main index file appended)\n");
     }
       /*
          4.) Quell- und Zieldatei nicht leer, Quelldatei wird
              mit Zeildatei gemischt
       */

     else
     {
       mrgeix01(journal_pix_name,tmpix_name,newix_name);
       remove(journal_pix_name);
       remove(tmpix_name);
       rename(newix_name,journal_pix_name);
       wrtxt("(Main index file merged)\n");

     }

       /* Abstract-Index: */

       /* bei mehreren Datensaetzen muss tmpixa_name sortiert werden: */
     if (filesize(tmpixa_name) > sizeof(abstrpix_rec))
     {
       domerge04(tmpixa_name,newix_name);
       remove(tmpixa_name);
       rename(newix_name,tmpixa_name);
     }

       /*
          Vier Faelle bei der Erstellung des neuen Abstract-Index:
          1.)  Ziel-Indexdatei noch leer
       */
     if (filesize (abstr_pix_name)== 0)
     {
        remove(abstr_pix_name);
        rename(tmpixa_name,abstr_pix_name);
        wrtxt("(Abstract index file created)\n");
     }
       /* 2.)  Quelldatei ist leer */
     else if (filesize(tmpixa_name)==0)
     {
        remove(tmpixa_name);
        wrtxt("(Abstract index file not touched)\n");
     }
       /*
          3.) Quell- und Zieldatei nicht leer, Quelldatei wird
              an Zeildatei angehaengt
       */
     else if (ok_appix04(abstr_pix_name,tmpixa_name))
     {
        appendix04(abstr_pix_name,tmpixa_name);
        remove(tmpixa_name);
        wrtxt("(Abstract index file appended)\n");
     }
       /*
          4.) Quell- und Zieldatei nicht leer, Quelldatei wird
              mit Zeildatei gemischt
       */
     else
     {
        mrgeix04(abstr_pix_name,tmpixa_name,newix_name);
        remove(abstr_pix_name);
        remove(tmpixa_name);
        rename(newix_name,abstr_pix_name);
        wrtxt("(Abstract index file merged)\n");
     }

     while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
     {
       if (locate_substring("****:BEGIN JOURNALS",in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
     }


     dateien02_initialisieren();

     archiv_02();

     close_ix02();
     fclose(tmpix);
     fclose(fpquell);

     if (filesize(tmpix_name) > sizeof(quellpix_rec))
     {
       domerge02(tmpix_name,newix_name);
       remove(tmpix_name);
       rename(newix_name,tmpix_name);
     }

     if (filesize(quell_pix_name) == 0)
     {
       remove(quell_pix_name);
       rename(tmpix_name,quell_pix_name);
       wrtxt("(Source index file created)\n");
     }
     else if (filesize(tmpix_name) == 0)
     {
        remove(tmpix_name);
        wrtxt("(Source index file not touched)\n");
     }
     else if (ok_appix02(quell_pix_name,tmpix_name))
     {
       appendix02(quell_pix_name,tmpix_name);
       remove(tmpix_name);
       wrtxt("(Source index file appended)\n");
     }
     else
     {
       mrgeix02(quell_pix_name,tmpix_name,newix_name);
       remove(quell_pix_name);
       remove(tmpix_name);
       rename(newix_name,quell_pix_name);
       wrtxt("(Source index file merged)\n");
     }

     while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
     {
       if (locate_substring("****:BEGIN KEYWORDS THESAURUS",in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
     }


     dateien03_initialisieren();
     archiv_03();
     close_ix03();
     fclose(tmpix);
     fclose(fpstichw);

     if (filesize(tmpix_name) > sizeof(keylistpix_rec))
     {
       domerge03(tmpix_name,newix_name);
       remove(tmpix_name);
       rename(newix_name,tmpix_name);
     }

     if (filesize(stichw_pix_name) == 0)
     {
       remove(stichw_pix_name);
       rename(tmpix_name,stichw_pix_name);
       wrtxt("(Key index file created)\n");
     }
     else if (filesize(tmpix_name) == 0)
     {
        remove(tmpix_name);
        wrtxt("(Key index file not touched)\n");
     }
     else if (ok_appix03(stichw_pix_name,tmpix_name))
     {
       appendix03(stichw_pix_name,tmpix_name);
       remove(tmpix_name);
       wrtxt("(Key index file appended)\n");
     }
     else
     {
       mrgeix03(stichw_pix_name,tmpix_name,newix_name);
       remove(stichw_pix_name);
       remove(tmpix_name);
       rename(newix_name,stichw_pix_name);
       wrtxt("(Key index file merged)\n");
     }


     if (import_ok)
     {
        sprintf(wrtxtbu,"Import from file `%s' completed without problems!",
        archiv_datei_name);
        logdatei_schreiben(wrtxtbu);
     }
     fclose(fparchiv);
     logdatei_schliessen();
     free(au_zeile);
     free(ed_zeile);
     free(in_zeile);
     free(ex_zeile);
     free(abs_zeile);
     free(desc_zeile);
     sprintf(wrtxtbu,"\nImport completed, please read `%s'\n",log_name);
     wrtxt(wrtxtbu);
     strcpy(ein,"menu");
     wrtxt("\nMenu: delete archive file [y/n]?\n");
     loeschen_taste = menu_wahl(ein,"[y] yes, delete archive file\n"
                                    "[n] do not delete archive file");
     if (loeschen_taste==1)
     {
         remove(archiv_datei_name);
     }
     
     return 0;
}
 
 
unsigned int blocks_required(const char * abstract)
{
    unsigned int nb, i; /* nb Anzahl Bloecke */
    i = strlen(abstract);

    if (i==0) i++;
    nb = i / ABSTEXT_LEN;
    if ((i % ABSTEXT_LEN) != 0)
       nb++;
    return nb;
}


static void dateien0104_initialisieren(void)
{
  if (!isfile(journal_pix_name))
  {
     if ((ix01file=fopen(journal_pix_name,"wb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot create %s\n",journal_pix_name);
       exit(1);
     }
     fclose(ix01file);
     read_ix01(journal_pix_name);
  }
  else
  {
     if ((ix01file=fopen(journal_pix_name,"rb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot read/write %s\n",journal_pix_name);
       exit(1);
     }
  }

   if (!isfile(abstr_pix_name))
   {
      if ((ix04file=fopen(abstr_pix_name,"wb"))==NULL)
      {
        fprintf(stderr,"\nError: cannot create %s\n",
           abstr_pix_name);
        exit(1);
      }
      fclose(ix04file);
   }
   if (!read_ix04(abstr_pix_name))
   {
        fprintf(stderr,"\nError: cannot read %s\n",
           abstr_pix_name);
        exit(1);
   }


  if (!isfile(journal_name))
  {
     if ((fpjournal=fopen(journal_name,"wb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot create %s\n",journal_name);
       exit(1);
     }
  }
  else
  {
     if ((fpjournal=fopen(journal_name,"r+b"))==NULL)
     {
       fprintf(stderr,"\nError: cannot read/write %s\n",journal_name);
       exit(1);
     }
  }


  if (!isfile(desc_name))
  {
     if ((fpdesc=fopen(desc_name,"wb"))==NULL)
     {
       fprintf(stderr,"\nERROR: cannot create %s\n",desc_name);
       exit(1);
     }
  }
  else
  {
     if ((fpdesc=fopen(desc_name,"r+b"))==NULL)
     {
       fprintf(stderr,"\nError: cannot read/write %s\n",desc_name);
       exit(1);
     }
  }


  if (!isfile(book_name))
  {
     if ((fpbuch=fopen(book_name,"wb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot create %s\n",book_name);
       exit(1);
     }
  }
  else
  {
     if ((fpbuch=fopen(book_name,"r+b"))==NULL)
     {
       fprintf(stderr,"\nError: cannot read/write %s\n",book_name);
       exit(1);
     }
  }


  if (!isfile(autorjl_name))
  {
     if ((fpautorjl=fopen(autorjl_name,"wb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot create %s\n",autorjl_name);
       exit(1);
     }
  }
  else
  {
     if ((fpautorjl=fopen(autorjl_name,"r+b"))==NULL)
     {
       fprintf(stderr,"\nError: cannot read/write %s\n",autorjl_name);
       exit(1);
     }
  }
  if (!isfile(autorbu_name))
  {
     if ((fpautorbu=fopen(autorbu_name,"wb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot create %s\n",autorbu_name);
       exit(1);
     }
  }
  else
  {
     if ((fpautorbu=fopen(autorbu_name,"r+b"))==NULL)
     {
       fprintf(stderr,"\nError: cannot read/write %s\n",autorbu_name);
       exit(1);
     }
  }
  if (!isfile(abstr_dat_name))
  {
     if ((fpabs=fopen(abstr_dat_name,"wb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot create %s\n",
           abstr_dat_name);
       fclose(ix04file);
       fclose(ix01file);
       exit(1);
     }
     fclose(fpabs);
  }
  if ((fpabs=fopen(abstr_dat_name,"r+b"))==NULL)
  {
        fprintf(stderr,"\nError: cannot read/write %s\n",
              abstr_dat_name);
        fclose(ix04file);
        fclose(ix01file);
        exit(1);
  }

  if ((tmpix = fopen(tmpix_name,"wb"))==NULL)
  {
      fprintf(stderr,"Error: cannot create %s\n",tmpix_name);
      exit(1);
  }
  if ((tmpixa = fopen(tmpixa_name,"wb"))==NULL)
  {
      fprintf(stderr,"\nError: cannot create %s\n",tmpixa_name);
      exit(1);
  }
}

static void archiv_datei_lesen(const char * name)
{
    if ((fparchiv=fopen(name,"r"))==NULL)
    {
        fprintf(stderr,"\nError: cannot read %s\n",name);
        exit(1);
    }
}



static void archiv_0104(void)
{
    long j;
    int ok;
    char altezeile[KENNZIFFER_LEN +1];
    long rec_zeiger, byte_zeiger;
    refspix_rec ix01rec_lokal;

    sprintf(wrtxtbu,"Import of records from archive file`%s'",
        archiv_datei_name);
    logdatei_schreiben(wrtxtbu);
    strncpy(altezeile,"",KENNZIFFER_LEN);
    j = 0;
    ok=1;
    memset(&one_journal_rec,0,sizeof(one_journal_rec));
    memset(&ix01rec,0,sizeof(ix01rec));
    memset(&one_buch_rec,0,sizeof(one_buch_rec));
    ix01rec.journal_rptr =-1;
    ix01rec.buch_rptr =-1;
    ix01rec.autorjl_rptr =-1;
    ix01rec.autorbu_rptr =-1;
    ix01rec.desc_rptr =-1;
    strcpy(au_zeile,"");
    strcpy(ed_zeile,"");
    strcpy(abs_zeile,"");
    strcpy(desc_zeile,"");
    while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
    {
        if (strlen(in_zeile) >= MAXARR - 1)
        {
          ok = 0;
          continue;
        }
        rtrim(in_zeile,'\n');
        if (locate_substring("****:END REFERENCES",in_zeile)==0 ||
            locate_substring("****:END ARCHIVE",in_zeile)==0)
        {
           break;
        }
        if (strlen(in_zeile) == 0)
        {
           memset(&one_journal_rec,0,sizeof(one_journal_rec));
           memset(&ix01rec,0,sizeof(ix01rec));
           memset(&one_buch_rec,0,sizeof(one_buch_rec));
           ix01rec.journal_rptr =-1;
           ix01rec.buch_rptr =-1;
           ix01rec.autorjl_rptr =-1;
           ix01rec.autorbu_rptr =-1;
           ix01rec.desc_rptr =-1;
           strcpy(au_zeile,"");
           strcpy(ed_zeile,"");
           strcpy(abs_zeile,"");

           ok=1;
           continue;
        }
        if (!ok)
        {
           memset(&one_journal_rec,0,sizeof(one_journal_rec));
           memset(&ix01rec,0,sizeof(ix01rec));
           memset(&one_buch_rec,0,sizeof(one_buch_rec));
           ix01rec.journal_rptr =-1;
           ix01rec.buch_rptr =-1;
           ix01rec.autorjl_rptr =-1;
           ix01rec.autorbu_rptr =-1;
           ix01rec.desc_rptr =-1;
           strcpy(au_zeile,"");
           strcpy(ed_zeile,"");
           strcpy(abs_zeile,"");
           continue;
        }

        if (locate_substring("RECN:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("RECN:"),
                        KENNZIFFER_LEN);
           strlimcpy(ix01rec.kennziffer,ex_zeile,KENNZIFFER_LEN);
           if (strcmp(altezeile,ix01rec.kennziffer) == 0)
           {
              sprintf(wrtxtbu,"`%s' not imported: key equal to "
                  "previous key (%s)",ex_zeile,altezeile);
              logdatei_schreiben(wrtxtbu);
              import_ok = 0;
              ok=0;
              strcpy(in_zeile,"");
              continue;
           }
           strlimcpy(altezeile,ex_zeile,KENNZIFFER_LEN);
           strcpy(in_zeile,"");
           continue;
        }


        if (locate_substring("DTYP:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("DTYP:"),
                        REFTYP_LEN);
           strlimcpy(one_journal_rec.reftyp,ex_zeile,REFTYP_LEN);
           strcpy(in_zeile,"");
           continue;

        }
        if(strlen(ix01rec.kennziffer)==0 ||
                  (strcmp(one_journal_rec.reftyp,"j1") !=0 &&
                   strcmp(one_journal_rec.reftyp,"j2") !=0 &&
                   strcmp(one_journal_rec.reftyp,"b1") !=0 &&
                   strcmp(one_journal_rec.reftyp,"b2") !=0 &&
                   strcmp(one_journal_rec.reftyp,"b3") !=0 &&
                   strcmp(one_journal_rec.reftyp,"m1") !=0 &&
                   strcmp(one_journal_rec.reftyp,"m2") !=0 ))
        {
           sprintf(wrtxtbu,"Problem with record `%s': "
            "impossible to identify document type: `%s'",
             ix01rec.kennziffer,one_journal_rec.reftyp);
           logdatei_schreiben(wrtxtbu);
           ok = 0;
           import_ok = 0;
           continue;
        }
        if (locate_substring("AUTH:",in_zeile)==0)
        {
           extract_subs(au_zeile,
                        in_zeile,
                        strlen("AUTH:"),
                        MAXARR);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("INAU:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("INAU:"),
                        TITEL_LEN);
           strlimcpy(one_journal_rec.instau,ex_zeile,INSTAU_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("TITA:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("TITA:"),
                        TITEL_LEN);
           strlimcpy(one_journal_rec.titel,ex_zeile,TITEL_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("HOWP:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("HOWP:"),
                        TITEL_LEN);
           strlimcpy(one_journal_rec.howpublished,ex_zeile,HOWPUBLISHED_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("JRNL:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("JRNL:"),
                        KUERZEL_LEN);
           strlimcpy(one_journal_rec.kuerzel,ex_zeile,KUERZEL_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("IDNR:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("IDNR:"),
                        IDNR_LEN);
           strlimcpy(one_journal_rec.idnr,ex_zeile,IDNR_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("YEAR:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("YEAR:"),
                        JAHRGANG_LEN);
           strlimcpy(one_journal_rec.jahrgang,ex_zeile,JAHRGANG_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("MONP:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("MONP:"),
                        MONAT_LEN);
           strlimcpy(one_journal_rec.monat,ex_zeile,MONAT_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("DAYP:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("DAYP:"),
                        TAG_LEN);
           strlimcpy(one_journal_rec.tag,ex_zeile,TAG_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("VOLM:",in_zeile)==0 ||
            locate_substring("EDTN:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("VOLM:"),
                        BAND_LEN);
           strlimcpy(one_journal_rec.band,ex_zeile,BAND_LEN);
           strcpy(in_zeile,"");
           continue;
        }

        if (locate_substring("ISNU:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("ISNU:"),
                        ISSUE_NUMMER_LEN);
           strlimcpy(one_journal_rec.issue_nummer,ex_zeile,ISSUE_NUMMER_LEN);
           strcpy(in_zeile,"");
           continue;
        }

        if (locate_substring("PGFR:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("PGFR:"),
                        SEITE_VON_LEN);
           strlimcpy(one_journal_rec.seite_von,ex_zeile,SEITE_VON_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("PGTO:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("PGTO:"),
                        SEITE_BIS_LEN);
           strlimcpy(one_journal_rec.seite_bis,ex_zeile,SEITE_BIS_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("STAT:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("STAT:"),
                        STATUS_LEN);
           strlimcpy(one_journal_rec.status,ex_zeile,STATUS_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("KEYW:",in_zeile)==0)
        {
           extract_subs(desc_zeile,
                        in_zeile,
                        strlen("KEYW:"),
                        DESC_ZEILE_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("EDIT:",in_zeile)==0)
        {
           extract_subs(ed_zeile,
                        in_zeile,
                        strlen("EDIT:"),
                        MAXARR);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("INED:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("INED:"),
                        TITEL_LEN);
           strlimcpy(one_buch_rec.insted,ex_zeile,INSTED_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("TITB:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("TITB:"),
                        TITELBUCH_LEN);
           strlimcpy(one_buch_rec.titel_bu,ex_zeile,TITELBUCH_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("PLAC:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("PLAC:"),
                        PUBLORT_LEN);
           strlimcpy(one_buch_rec.publ_ort,ex_zeile,PUBLORT_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("PUBL:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("PUBL:"),
                        VERLAG_LEN);
           strlimcpy(one_buch_rec.verlag,ex_zeile,VERLAG_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("ISBN:",in_zeile)==0)
        {
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("ISBN:"),
                        ISBN_LEN);
           strlimcpy(one_buch_rec.isbn,ex_zeile,ISBN_LEN);
           strcpy(in_zeile,"");
           continue;
        }
        if (locate_substring("ABST:",in_zeile)==0)
        {
           extract_subs(abs_zeile,
                        in_zeile,
                        strlen("ABST:"),
                        ABSTRACT_ZEILE_LEN);


           if (locate_ix01(ix01rec.kennziffer,&ix01rec_lokal)!=-1)
           {
              strcpy(in_zeile,"");
              ok=0;
              sprintf(wrtxtbu,"Information: record `%s' not imported: key "
                  "already found in database",ix01rec.kennziffer);
              logdatei_schreiben(wrtxtbu);
              continue;
           }

           if (strlen(desc_zeile)>0)
           {
              desc_speichern(ix01rec.kennziffer,desc_zeile);
           }
           else
           {
              strcpy(desc_zeile,"--dummy keyword--");
              desc_speichern(ix01rec.kennziffer,desc_zeile);
           }

           if (strlen(abs_zeile)>0)
           {
              archiv_speichern(ix01rec.kennziffer,abs_zeile);
           }
           strlimcpy(one_journal_rec.kennziffer,ix01rec.kennziffer,KENNZIFFER_LEN);
           strlimcpy(one_buch_rec.kennziffer,ix01rec.kennziffer,KENNZIFFER_LEN);
           one_journal_rec.in_use=1;

           fseek(fpjournal,0L,SEEK_END);
           byte_zeiger = ftell(fpjournal);
           rec_zeiger = byte_zeiger / sizeof(one_journal_rec);
           ix01rec.journal_rptr = rec_zeiger;
           if (fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal) < 1) schreibfehler();

           // if (!strcmp(one_journal_rec.reftyp,"j1"))
           if ((!strcmp(one_journal_rec.reftyp,"j1"))|| 
             (!strcmp(one_journal_rec.reftyp,"m1")))
           {
             trim(au_zeile,' ');
             if (strlen(au_zeile)==0)
             {
               strcpy(au_zeile,"?,?");
             }
             aued_speichern(au_zeile,fpautorjl,&rec_zeiger);
             ix01rec.autorjl_rptr = rec_zeiger;

             fseek(tmpix,0L,SEEK_END);
             if (fwrite(&ix01rec,sizeof(ix01rec),1,tmpix) < 1) schreibfehler();
           }

           if ((!strcmp(one_journal_rec.reftyp,"j2"))||
               (!strcmp(one_journal_rec.reftyp,"m2")))
           {
             // trim(au_zeile,' ');
             // if (strlen(au_zeile)==0)
             // {
             //   strcpy(au_zeile,"?,?");
             // }
             // aued_speichern(au_zeile,fpautorjl,&rec_zeiger);
             // ix01rec.autorjl_rptr = rec_zeiger;

             fseek(tmpix,0L,SEEK_END);
             if (fwrite(&ix01rec,sizeof(ix01rec),1,tmpix) < 1) schreibfehler();
           }

           if (!strcmp(one_journal_rec.reftyp,"b1"))
           {
             one_buch_rec.in_use_bu=1;
             fseek(fpbuch,0L,SEEK_END);
             byte_zeiger = ftell(fpbuch);
             rec_zeiger = byte_zeiger / sizeof(one_buch_rec);
             ix01rec.buch_rptr = rec_zeiger;
             if (fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch) < 1) schreibfehler();
             trim(ed_zeile,' ');
             if (strlen(ed_zeile)==0)
             {
               strcpy(ed_zeile,"?,?");
             }
             aued_speichern(ed_zeile,fpautorbu,&rec_zeiger);
             ix01rec.autorbu_rptr = rec_zeiger;

             fseek(tmpix,0L,SEEK_END);
             if (fwrite(&ix01rec,sizeof(ix01rec),1,tmpix) < 1) schreibfehler();
           }
           if (!strcmp(one_journal_rec.reftyp,"b2"))
           {
             one_buch_rec.in_use_bu=1;
             fseek(fpbuch,0L,SEEK_END);
             byte_zeiger = ftell(fpbuch);
             rec_zeiger = byte_zeiger / sizeof(one_buch_rec);
             ix01rec.buch_rptr = rec_zeiger;
             if (fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch) < 1) schreibfehler();

             trim(ed_zeile,' ');
             if (strlen(ed_zeile)==0)
             {
               strcpy(ed_zeile,"?,?");
             }
             aued_speichern(ed_zeile,fpautorbu,&rec_zeiger);
             ix01rec.autorbu_rptr = rec_zeiger;
             trim(ed_zeile,' ');
             if (strlen(au_zeile)==0)
             {
               strcpy(au_zeile,"?,?");
             }
             aued_speichern(au_zeile,fpautorjl,&rec_zeiger);
             ix01rec.autorjl_rptr = rec_zeiger;

             fseek(tmpix,0L,SEEK_END);
             if (fwrite(&ix01rec,sizeof(ix01rec),1,tmpix) < 1) schreibfehler();
           }
           if (!strcmp(one_journal_rec.reftyp,"b3"))
           {
             one_buch_rec.in_use_bu=1;
             fseek(fpbuch,0L,SEEK_END);
             byte_zeiger = ftell(fpbuch);
             rec_zeiger = byte_zeiger / sizeof(one_buch_rec);
             ix01rec.buch_rptr = rec_zeiger;
             if (fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch) < 1) schreibfehler();
             // trim(ed_zeile,' ');
             // if (strlen(ed_zeile)==0)
             // {
             //   strcpy(ed_zeile,"?,?");
             // }
             // aued_speichern(ed_zeile,fpautorbu,&rec_zeiger);
             // ix01rec.autorbu_rptr = rec_zeiger;

             fseek(tmpix,0L,SEEK_END);
             if (fwrite(&ix01rec,sizeof(ix01rec),1,tmpix) < 1) schreibfehler();
           }
           
           
           
           strcpy(in_zeile,"");
           ok=0;
           continue;

        } /* ABST:...  */
        ok=0;
        sprintf(wrtxtbu,"At least one problem with record `%s' "
            "(not imported)",ix01rec.kennziffer);
        logdatei_schreiben(wrtxtbu);
        import_ok = 0;
    } /* while(fgets...) */

}
 

static void aued_speichern(const char * zeile, FILE * fpaued, long * aued_rptr)
{
   int i,anzahl_au;
   long rec_zeiger, byte_zeiger;
   char a_name[2 * AUNAME_LEN + 12];
   char v_name[2 * AUNAME_LEN + 12];
   author_rec    aued_rec;

   anzahl_au = countitem(zeile,";");
   if (anzahl_au > MAX_N_AUTHORS) anzahl_au = MAX_N_AUTHORS;
   memset(&aued_rec,0,sizeof(aued_rec));
   fseek(fpaued,0L,SEEK_END);
   byte_zeiger = ftell(fpaued);
   rec_zeiger = byte_zeiger / sizeof(aued_rec);
   * aued_rptr = rec_zeiger;
   for (i=1;i<=anzahl_au;i++)
   {
      extractitem(i,zeile,";",ex_zeile);
      ex_zeile[AUNAME_LEN + AUVORNAMEN_LEN + 12] = '\0';
      extractitem(1,ex_zeile,",",a_name);
      trim(a_name,' ');
      a_name[AUNAME_LEN] = '\0';
      extractitem(2,ex_zeile,",",v_name);
      trim(v_name,' ');
      if(strlen(v_name)==0) strcpy(v_name,"?");
      v_name[AUVORNAMEN_LEN] = '\0';
      aued_rec.in_use_au = 1;
      aued_rec.au_i = i;
      aued_rec.au_n = anzahl_au;
      strncpy(aued_rec.au_kennziffer,ix01rec.kennziffer,KENNZIFFER_LEN + 1);
      strncpy(aued_rec.au_nachname,a_name,AUNAME_LEN +1);
      strncpy(aued_rec.au_vornamen,v_name,AUVORNAMEN_LEN +1);
      if (fwrite(&aued_rec,sizeof(aued_rec),1,fpaued) < 1) schreibfehler();
   }
}

static void desc_speichern(char * kennziffer,char * zeile)
{
   int i, anzahl_desc;
   long rec_zeiger, byte_zeiger;
   anzahl_desc = countitem(zeile,",");
   if (anzahl_desc > MAX_N_DESC)
   {
       anzahl_desc = MAX_N_DESC;
   }
   memset(&one_desc_rec,0,sizeof(one_desc_rec));
   fseek(fpdesc,0L,SEEK_END);
   byte_zeiger=ftell(fpdesc);
   rec_zeiger = byte_zeiger/sizeof(one_desc_rec);
   ix01rec.desc_rptr = rec_zeiger;
   for (i=1;i<=anzahl_desc;i++)
   {
      extractitem(i,zeile,",",ex_zeile);
      trim(ex_zeile,' ');
      one_desc_rec.in_use = 1;
      one_desc_rec.desc_i = i;
      one_desc_rec.desc_n = anzahl_desc;
      strlimcpy(one_desc_rec.kennziffer,kennziffer,KENNZIFFER_LEN);
      strlimcpy(one_desc_rec.keywordsfield,ex_zeile,KEYWORDS_LEN);
      if (fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc) < 1) schreibfehler();
   }
}


static void dateien02_initialisieren(void)
{
  if (!isfile(quell_pix_name))
  {
     if ((ix02file=fopen(quell_pix_name,"wb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot create %s\n",quell_pix_name);
       exit(1);
     }
     fclose(ix02file);
     read_ix02(quell_pix_name);
  }
  else
  {
     if ((ix02file=fopen(quell_pix_name,"rb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot read/write %s\n",quell_pix_name);
       exit(1);
     }
  }

  if (!isfile(quell_name))
  {
     if ((fpquell=fopen(quell_name,"wb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot create %s\n",quell_name);
       exit(1);
     }
  }
  else
  {
     if ((fpquell=fopen(quell_name,"r+b"))==NULL)
     {
       fprintf(stderr,"\nError: cannot read/write %s\n",quell_name);
       exit(1);
     }
  }

  if ((tmpix = fopen(tmpix_name,"wb"))==NULL)
  {
      fprintf(stderr,"\nError: cannot create %s\n",tmpix_name);
      exit(1);
  }

}

static void archiv_02(void)
{
    long j;
    char altezeile[QUELLKUERZEL_LEN + 1];
    long rec_zeiger, byte_zeiger;
    quellpix_rec ix02rec_lokal;
    int ok;

    strncpy(altezeile,"",QUELLKUERZEL_LEN);
    j = 0;
    ok=1;
    memset(&one_quell_rec,0,sizeof(one_quell_rec));
    memset(&ix02rec,0,sizeof(ix02rec));
    ix02rec.quell_rptr =-1;
    while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
    {
        if (strlen(in_zeile) >= MAXARR - 1)
        {
           ok=0;
           continue;
        }
        rtrim(in_zeile,'\n');
        if (locate_substring("****:END JOURNALS",in_zeile)==0 ||
            locate_substring("****:END ARCHIVE",in_zeile)==0)
        {
           break;
        }
        if (strlen(in_zeile)==0)
        {
            memset(&one_quell_rec,0,sizeof(one_quell_rec));
            memset(&ix02rec,0,sizeof(ix02rec));
            ix02rec.quell_rptr =-1;
            ok=1;
            continue;
        }
        if (!ok)
        {
            continue;
        }
        if (locate_substring("JCOD:",in_zeile)==0)
        {
            extract_subs(ex_zeile,
                         in_zeile,
                         strlen("JCOD:"),
                         QUELLKUERZEL_LEN
                        );
            strlimcpy(one_quell_rec.quell_kuerzel,ex_zeile,
                 QUELLKUERZEL_LEN);
            strlimcpy(ix02rec.quell_kuerzel,ex_zeile,
                 QUELLKUERZEL_LEN);
            if(strcmp_fun(altezeile,ex_zeile,SSTRING) == 0)
            {
                 sprintf(wrtxtbu,"`%s' not imported: key equal to "
                    "previous key (%s)",ex_zeile,altezeile);
                 logdatei_schreiben(wrtxtbu);
                 ok=0;
                 strcpy(in_zeile,"");
                 continue;
            }
            strlimcpy(altezeile,ex_zeile,QUELLKUERZEL_LEN),
            strcpy(in_zeile,"");
            continue;
        }
        if (strlen(ix02rec.quell_kuerzel)==0)
        {
            ok=0;
            continue;
        }
        if (locate_substring("ISSN:",in_zeile)==0)
        {
            extract_subs(ex_zeile,
                         in_zeile,
                         strlen("ISSN:"),
                         ISSN_LEN
                        );
            strlimcpy(one_quell_rec.quell_issn,ex_zeile,
                         ISSN_LEN);
            strcpy(in_zeile,"");
            continue;

        }
        if (locate_substring("JNAM:",in_zeile)==0)
        {
            extract_subs(ex_zeile,
                         in_zeile,
                         strlen("JNAM:"),
                         ZEITSCHRIFT_LEN
                        );
            strlimcpy(one_quell_rec.quell_zeitschrift,ex_zeile,
                         ZEITSCHRIFT_LEN);
            strcpy(in_zeile,"");
            continue;

        }
        if (locate_substring("JS01:",in_zeile)==0)
        {
            extract_subs(ex_zeile,
                         in_zeile,
                         strlen("JS01:"),
                         KURZFORM_LEN
                        );
            strlimcpy(one_quell_rec.quell_kurzform,ex_zeile,
                         KURZFORM_LEN);
            strcpy(in_zeile,"");
            if (locate_ix02(ix02rec.quell_kuerzel,&ix02rec_lokal)==-1)
            {
              one_quell_rec.in_use_quell = 1;

              fseek(fpquell,0L,SEEK_END);
              byte_zeiger = ftell(fpquell);
              rec_zeiger = byte_zeiger / sizeof(one_quell_rec);
              ix02rec.quell_rptr = rec_zeiger;
              if (fwrite(&one_quell_rec,sizeof(one_quell_rec),1,fpquell) < 1) schreibfehler();

              fseek(tmpix,0L,SEEK_END);
              if (fwrite(&ix02rec,sizeof(ix02rec),1,tmpix) < 1) schreibfehler();

              strcpy(in_zeile,"");
              ok=0;
              continue;
            }

        }


    } /* while (fgets...*/
    return;

}


static void dateien03_initialisieren(void)
{
  if (!isfile(stichw_pix_name))
  {
     if ((ix03file=fopen(stichw_pix_name,"wb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot create %s\n",stichw_pix_name);
       exit(1);
     }
     fclose(ix03file);
     read_ix03(stichw_pix_name);
  }
  else
  {
     if ((ix03file=fopen(stichw_pix_name,"rb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot read/write %s\n",stichw_pix_name);
       exit(1);
     }
  }

  if (!isfile(stichw_name))
  {
     if ((fpstichw=fopen(stichw_name,"wb"))==NULL)
     {
       fprintf(stderr,"\nError: cannot create %s\n",stichw_name);
       exit(1);
     }
  }
  else
  {
     if ((fpstichw=fopen(stichw_name,"r+b"))==NULL)
     {
       fprintf(stderr,"\nError: cannot read/write %s\n",stichw_name);
       exit(1);
     }
  }

  if ((tmpix = fopen(tmpix_name,"wb"))==NULL)
  {
      fprintf(stderr,"\nError: cannot create %s\n",tmpix_name);
      exit(1);
  }
}




static void archiv_03(void)
{
    long j;
    int ok;
    char altezeile[KEYWORDS_LEN + 1];
    long rec_zeiger, byte_zeiger;
    keylistpix_rec ix03rec_lokal;

    strncpy(altezeile,"",KEYWORDS_LEN);
    j = 0;
    ok=1;
    memset(&one_key_rec,0,sizeof(one_key_rec));
    memset(&ix03rec,0,sizeof(ix03rec));
    ix03rec.keywords_rptr = -1;
    while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
    {
        if (strlen(in_zeile) >= MAXARR - 1)
        {
           ok=0;
           continue;
        }
        rtrim(in_zeile,'\n');
        if (locate_substring("****:END KEYWORDS THESAURUS",in_zeile)==0 ||
            locate_substring("****:END ARCHIVE",in_zeile)==0)
        {
           break;
        }
        if (strlen(in_zeile)==0)
        {
            memset(&one_key_rec,0,sizeof(one_key_rec));
            memset(&ix03rec,0,sizeof(ix03rec));
            ix03rec.keywords_rptr = -1;
            ok=1;
            continue;
        }
        if (!ok)
        {
            continue;
        }
        if (locate_substring("KEYT:",in_zeile)==0)
        {
            extract_subs(ex_zeile,
                         in_zeile,
                         strlen("KEYT:"),
                         KEYWORDS_LEN);
            strlimcpy(one_key_rec.keywordsfield,ex_zeile,KEYWORDS_LEN);
            strlimcpy(ix03rec.keywordsfield,ex_zeile,KEYWORDS_LEN);
            if (strcmp_fun(altezeile,ex_zeile,SSTRING) == 0)
            {
                sprintf(wrtxtbu,"`%s' not imported: key equal to "
                  "previous key (%s)",ex_zeile,altezeile);
                logdatei_schreiben(wrtxtbu);
                ok = 0;
                strcpy(in_zeile,"");
                continue;
            }
            strlimcpy(altezeile,ex_zeile,KEYWORDS_LEN);

            if (locate_ix03(ix03rec.keywordsfield,&ix03rec_lokal)==-1)
            {
               one_key_rec.in_use = 1;

               fseek(fpstichw,0L,SEEK_END);
               byte_zeiger = ftell(fpstichw);
               rec_zeiger = byte_zeiger / sizeof(one_key_rec);
               ix03rec.keywords_rptr = rec_zeiger;
               if (fwrite(&one_key_rec,sizeof(one_key_rec),1,fpstichw) < 1) schreibfehler();

               fseek(tmpix,0L,SEEK_END);
               if (fwrite(&ix03rec,sizeof(ix03rec),1,tmpix) < 1) schreibfehler();
            }
            strcpy(in_zeile,"");
            ok=0;
            continue;

        }
    } /* while (fgets.. */
    return;

}

 
/* Name 'verunglueckt', sollte abstract_speichern() heissen! */
static int archiv_speichern(char * kennziffer, char * zeile)
{
   long j;
   long rec_zeiger, byte_zeiger, anzahl_bloecke, ix04_zeiger;
   abstrpix_rec ix04rec_lokal;
   unsigned int laenge;


   j=0;
   ix04_zeiger = locate_ix04(ex_zeile,&ix04rec_lokal);

   if (ix04_zeiger == -1)
   {
      long ii, jj, kk;
      anzahl_bloecke = blocks_required(zeile);
      if(anzahl_bloecke > MAX_BLOECKE)
          anzahl_bloecke = MAX_BLOECKE;
      fseek(fpabs,0L,SEEK_END);
      byte_zeiger = ftell(fpabs);
      rec_zeiger = byte_zeiger / sizeof(one_abstr_rec);

      laenge = strlen(zeile);
      jj = 0;
         /* Adressen in ex_zeile */

         /* Den Abstract-Text in Bloecke schreiben: */
      for (ii=1;ii <=anzahl_bloecke;ii++)
      {
          memset(&one_abstr_rec,0,sizeof(one_abstr_rec));
          one_abstr_rec.in_use = 1;
          one_abstr_rec.abstr_i = ii;
          one_abstr_rec.abstr_n = anzahl_bloecke;
          strncpy(one_abstr_rec.kennziffer,kennziffer,KENNZIFFER_LEN+1);
          kk=0;
            /* kk: Adresse in one_abstr_rec.abs_text */
          for (kk=0;kk < ABSTEXT_LEN;kk++)
          {
            if (jj < laenge)
            {
              one_abstr_rec.abs_text[kk] = zeile[jj++];
            }
          }
          if (fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs) < 1) schreibfehler();
      }
      memset(&ix04rec,0,sizeof(ix04rec));
      ix04rec.abstr_rptr = rec_zeiger;
      strncpy(ix04rec.kennziffer,kennziffer,KENNZIFFER_LEN + 1);
      fseek(tmpixa,0L,SEEK_END);
      if (fwrite(&ix04rec,sizeof(ix04rec),1,tmpixa) < 1) schreibfehler();
   }
   return 1;
}
 
/* Gibt '0' zureck, wenn Duplikate gefunden, sonst '1' */
static int no_dup0104(void)
{
  refspix_rec ix01rec_lokal, ix01rec_alt;
  int ok;

  ok = 1;
  if ((tmpix = fopen(tmpix_name,"wb"))==NULL)
  {
      fprintf(stderr,"\nError: cannot create %s\n",tmpix_name);
      exit(1);
  }
  while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
  {
      if (strlen(in_zeile) >= MAXARR - 1)
      {
        ok = 0;
        sprintf(wrtxtbu,"\nDuplicate key check: input line too long\n");
        wrtxt(wrtxtbu);
        break;
      }
      rtrim(in_zeile,'\n');
      if (locate_substring("****:END REFERENCES",in_zeile)==0 ||
          locate_substring("****:END ARCHIVE",in_zeile)==0)
      {
         break;
      }

      if (locate_substring("RECN:",in_zeile)==0)
      {
           memset(&ix01rec_lokal,0,sizeof(ix01rec_lokal));
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("RECN:"),
                        KENNZIFFER_LEN);
           if (strlen(ex_zeile) > 0)
           {
             strlimcpy(ix01rec_lokal.kennziffer,ex_zeile,KENNZIFFER_LEN);
             if (fwrite(&ix01rec_lokal,sizeof(ix01rec_lokal),1,tmpix) < 1) schreibfehler();
           }
      }
  } /* ... while (fgets(in_zeile,MAXARR,fparchiv)!=NULL) */

  fclose(tmpix);


  if (ok!=0)
  {
     /* sortieren, nach Duplikaten suchen... */
     long i, anzahl_records;
     if (filesize(tmpix_name) > sizeof(ix01rec_lokal))
     {
       domerge01(tmpix_name,newix_name);
       remove(tmpix_name);
       rename(newix_name,tmpix_name);

       if ((tmpix = fopen(tmpix_name,"rb"))==NULL)
       {
        fprintf(stderr,"\nError: cannot read %s\n",tmpix_name);
        exit(1);
       }
       /* nach Duplikaten suchen */

       memset(&ix01rec_lokal,0,sizeof(ix01rec_lokal));
       memset(&ix01rec_alt,0,sizeof(ix01rec_alt));
       fseek(tmpix,0L,SEEK_END);
       anzahl_records = ftell(tmpix) / sizeof(ix01rec_lokal) -1;
       rewind(tmpix);
       for (i=0;i<=anzahl_records;i++)
       {
           fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,tmpix);
           if (strcmp(ix01rec_lokal.kennziffer,ix01rec_alt.kennziffer)==0)
           {
             ok = 0;
             wrtxt("\nAt least one duplicate key!\n");
             break;
           }
           ix01rec_alt=ix01rec_lokal;
       }
       fclose(tmpix);
       if (isfile(tmpix_name))
       {
          remove(tmpix_name);
       }
     }

  }
  return ok;
}

/* Gibt '0' zureck, wenn Duplikate gefunden, sonst '1' */
static int no_dup02(void)
{
  int ok;
  quellpix_rec ix02rec_lokal, ix02rec_alt;
  ok = 1;

  if ((tmpix = fopen(tmpix_name,"wb"))==NULL)
  {
      fprintf(stderr,"\nError: cannot create %s\n",tmpix_name);
      exit(1);
  }
  while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
  {
      if (strlen(in_zeile) >= MAXARR - 1)
      {
        ok = 0;
        sprintf(wrtxtbu,"\nDuplicate key check: input line too long\n");
        wrtxt(wrtxtbu);
        break;
      }
      rtrim(in_zeile,'\n');
      if (locate_substring("****:END JOURNALS",in_zeile)==0 ||
          locate_substring("****:END ARCHIVE",in_zeile)==0)
      {
         break;
      }
      if (locate_substring("JCOD:",in_zeile)==0)
      {
           memset(&ix02rec_lokal,0,sizeof(ix02rec_lokal));
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("JCOD:"),
                        QUELLKUERZEL_LEN);
           if (strlen(ex_zeile) > 0)
           {
             strlimcpy(ix02rec_lokal.quell_kuerzel,ex_zeile,QUELLKUERZEL_LEN);
             if (fwrite(&ix02rec_lokal,sizeof(ix02rec_lokal),1,tmpix) < 1) schreibfehler();
           }
      }

  } /* while (fgets(in_zeile,MAXARR,fparchiv)!=NULL) */
  fclose(tmpix);
  if (ok!=0)
  {
     /* sortieren, nach Duplikaten suchen... */
     long i, anzahl_records;
     if (filesize(tmpix_name) > sizeof(ix02rec_lokal))
     {
       domerge02(tmpix_name,newix_name);
       remove(tmpix_name);
       rename(newix_name,tmpix_name);

       if ((tmpix = fopen(tmpix_name,"rb"))==NULL)
       {
        fprintf(stderr,"Error: cannot read %s\n",tmpix_name);
        exit(1);
       }
       /* nach Duplikaten suchen */

       memset(&ix02rec_lokal,0,sizeof(ix02rec_lokal));
       memset(&ix02rec_alt,0,sizeof(ix02rec_alt));
       fseek(tmpix,0L,SEEK_END);
       anzahl_records = ftell(tmpix) / sizeof(ix02rec_lokal) -1;
       rewind(tmpix);
       for (i=0;i<=anzahl_records;i++)
       {
           fread(&ix02rec_lokal,sizeof(ix02rec_lokal),1,tmpix);
           if (strcmp_fun(ix02rec_lokal.quell_kuerzel,ix02rec_alt.quell_kuerzel,SSTRING)==0)
           {
             ok = 0;
             wrtxt("\nAt least one duplicate key!\n");
             break;
           }
           ix02rec_alt=ix02rec_lokal;
       }
       fclose(tmpix);
       if (isfile(tmpix_name))
       {
          remove(tmpix_name);
       }
     }
  }
  return ok;
}

/* Gibt '0' zureck, wenn Duplikate gefunden, sonst '1' */
static int no_dup03(void)
{
  int ok;
  keylistpix_rec ix03rec_lokal, ix03rec_alt;
  ok = 1;

  if ((tmpix = fopen(tmpix_name,"wb"))==NULL)
  {
      fprintf(stderr,"\nError: cannot create %s\n",tmpix_name);
      exit(1);
  }
  while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
  {
      if (strlen(in_zeile) >= MAXARR - 1)
      {
        ok = 0;
        sprintf(wrtxtbu,"\nDuplicate key check: input line too long\n");
        wrtxt(wrtxtbu);
        break;
      }
      rtrim(in_zeile,'\n');
      if (locate_substring("****:END KEYWORDS THESAURUS",in_zeile)==0 ||
          locate_substring("****:END ARCHIVE",in_zeile)==0)
      {
         break;
      }
      if (locate_substring("KEYT:",in_zeile)==0)
      {
           memset(&ix03rec_lokal,0,sizeof(ix03rec_lokal));
           extract_subs(ex_zeile,
                        in_zeile,
                        strlen("KEYT:"),
                        KEYWORDS_LEN);
           if (strlen(ex_zeile) > 0)
           {
             strlimcpy(ix03rec_lokal.keywordsfield,ex_zeile,KEYWORDS_LEN);
             if (fwrite(&ix03rec_lokal,sizeof(ix03rec_lokal),1,tmpix) < 1) schreibfehler();
           }
      }

  } /* while (fgets(in_zeile,MAXARR,fparchiv)!=NULL) */
  fclose(tmpix);
  if (ok!=0)
  {
     /* sortieren, nach Duplikaten suchen... */
     long i, anzahl_records;
     if (filesize(tmpix_name) > sizeof(ix03rec_lokal))
     {
       domerge03(tmpix_name,newix_name);
       remove(tmpix_name);
       rename(newix_name,tmpix_name);

       if ((tmpix = fopen(tmpix_name,"rb"))==NULL)
       {
        fprintf(stderr,"\nError: cannot read %s\n",tmpix_name);
        exit(1);
       }
       /* nach Duplikaten suchen */

       memset(&ix03rec_lokal,0,sizeof(ix03rec_lokal));
       memset(&ix03rec_alt,0,sizeof(ix03rec_alt));
       fseek(tmpix,0L,SEEK_END);
       anzahl_records = ftell(tmpix) / sizeof(ix03rec_lokal) -1;
       rewind(tmpix);
       for (i=0;i<=anzahl_records;i++)
       {
           fread(&ix03rec_lokal,sizeof(ix03rec_lokal),1,tmpix);
           if (strcmp_fun(ix03rec_lokal.keywordsfield,ix03rec_alt.keywordsfield,SSTRING)==0)
           {
             ok = 0;
             wrtxt("\nAt least one duplicate key!\n");
             break;
           }
           ix03rec_alt=ix03rec_lokal;
       }
       fclose(tmpix);
       if (isfile(tmpix_name))
       {
          remove(tmpix_name);
       }
     }
  }
  return ok;
}
 
/*
 *  Liest die Archivdatei und gibt '0' zurueck, wenn Duplikate bei den
 *  Schluesseln gefunden, sonst '1' (intaktes Archiv)
 */
static int no_duplicates(char * archivname)
{

  if ((fparchiv=fopen(archivname,"r"))==NULL)
  {
     return 0;
  }

  wrtxt("\n(Searching for duplicate keys)\n");

  while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
  {
    if (locate_substring("****:BEGIN ARCHIVE",in_zeile)==0)
    {
      strcpy(in_zeile,"");
      break;
    }
  }
  while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
  {
    if (locate_substring("****:BEGIN REFERENCES",in_zeile)==0)
    {
      strcpy(in_zeile,"");
      break;
    }
  }

  if (no_dup0104()==0)
  {
     /* leider doppelte Schluessel gefunden */
     fclose(fparchiv);
     return 0;
  }

  while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
  {
    if (locate_substring("****:BEGIN JOURNALS",in_zeile)==0)
    {
      strcpy(in_zeile,"");
      break;
    }
  }

  if (no_dup02()==0)
  {
     /* leider doppelte Schluessel gefunden */
     fclose(fparchiv);
     return 0;
  }

  while (fgets(in_zeile,MAXARR,fparchiv)!=NULL)
  {
    if (locate_substring("****:BEGIN KEYWORDS THESAURUS",in_zeile)==0)
    {
      strcpy(in_zeile,"");
      break;
    }
  }

  if (no_dup03()==0)
  {
     /* leider doppelte Schluessel gefunden */
     fclose(fparchiv);
     return 0;
  }

  fclose(fparchiv);
  return 1;
}

