## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "httpHandler.tcl"
 #                                    created: 23/9/97 {1:58:27 pm} 
 #                                last update: 31/1/1999 {2:31:47 pm} 
 #  Author: Vince Darley
 #  E-mail: <darley@fas.harvard.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.fas.harvard.edu/~darley/>
 #  
 # Copyright (c) 1997-1998  Vince Darley, all rights reserved
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # ###################################################################
 ##

alpha::extension httpHandler 0.1 {
	eventHandler GURL GURL GURLHandler
}
	
proc httpGURLhandler {what} {
	global PREFS HOME
	set httpDir ${PREFS}:httptmp
	if {![file exists $httpDir]} {
		mkdir $httpDir
	}
	set tools ${HOME}:Tools
	regexp {[^/:]*.$} $what local
	set i 0
	while {[file exists ${tools}:tmp$i]} {incr i}
	set f ${tools}:tmp$i
	set fout [open $f w]
	puts $fout "Http_Copy http:${what} $httpDir:$local"
	puts $fout "return {httpHandled http:${what} $httpDir:$local}"
	close $fout
	# now open the file with Genii
	sendOpenEvent noReply [nameFromAppl Geni] $f
}

proc httpHandled {url local} {
	alertnote "Downloaded $url into $local"
}

## 
 # -------------------------------------------------------------------------
 #	 
 # "GURLHandler" --
 #	
 #	Handle general GURL	events by extracting the type 'ftp', 'http',
 #	and	calling	a procedure	${type}GURLHandler with	a single parameter
 #	which is the extracted resource.  Can be put to more general use.
 # -------------------------------------------------------------------------
 ##
proc GURLHandler {msg} {
	if {![regsub {.*(.*).*} $msg {\1} gurl]} {
		alertnote "Didn't understand GURL: $msg"
		return
	}
	set GURLtype [lindex [split $gurl ":"] 0]
	set GURLvalue [string range $gurl [expr 1+[string length $GURLtype]] end]
	if {[catch {${GURLtype}GURLHandler $GURLvalue} msg]} {
		message $msg
	}
}
